// @(#)root/reflex:$Id: UnionBuilder.cxx 20883 2007-11-19 11:52:08Z rdm $
// Author: Stefan Roiser 2004

// Copyright CERN, CH-1211 Geneva 23, 2004-2006, All rights reserved.
//
// Permission to use, copy, modify, and distribute this software for any
// purpose is hereby granted without fee, provided that this copyright and
// permissions notice appear in all copies and derivatives.
//
// This software is provided "as is" without express or implied warranty.

#ifndef REFLEX_BUILD
#define REFLEX_BUILD
#endif

#include "Reflex/Builder/UnionBuilder.h"

#include "Reflex/Member.h"
#include "Reflex/Any.h"

#include "DataMember.h"
#include "Union.h"

//-------------------------------------------------------------------------------
ROOT::Reflex::UnionBuilderImpl::UnionBuilderImpl( const char * nam,
                                                  size_t size,
                                                  const std::type_info & ti,
                                                  unsigned int modifiers ) {
//-------------------------------------------------------------------------------
// Construct union info.
   fUnion = new Union( nam, size, ti, modifiers );
}


//-------------------------------------------------------------------------------
void ROOT::Reflex::UnionBuilderImpl::AddItem( const char * nam,
                                              const Type & typ ) {
//-------------------------------------------------------------------------------
// Add a union info to this union.
   fLastMember = Member(new DataMember( nam,
                                        typ,
                                        0,
                                        0 ));
   fUnion->AddDataMember( fLastMember );
}


//-------------------------------------------------------------------------------
void ROOT::Reflex::UnionBuilderImpl::AddProperty( const char * key,
                                                  Any value ) {
//-------------------------------------------------------------------------------
// Attach property to this union as Any object.
   if ( fLastMember ) fLastMember.Properties().AddProperty( key, value );
   else                fUnion->Properties().AddProperty(key, value );
}


//-------------------------------------------------------------------------------
void ROOT::Reflex::UnionBuilderImpl::AddProperty( const char * key,
                                                  const char * value ) {
//-------------------------------------------------------------------------------
// Attach property to this union as string.
   AddProperty( key, Any(value));
}


//-------------------------------------------------------------------------------
ROOT::Reflex::Type ROOT::Reflex::UnionBuilderImpl::ToType() {
//-------------------------------------------------------------------------------
// Return the type currently being built.
   return fUnion->ThisType();
}
