//plugins.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2012
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _PLUGINS_H_
#define _PLUGINS_H_

#include <roaraudio.h>

#define ROARD_DL_APPNAME    "roard " ROAR_VSTR_ROARAUDIO
#define ROARD_DL_ABIVERSION "1.0beta1"

struct roard_plugins_sched {
 int (*init)(void);
 int (*free)(void);
 int (*update)(void);
};

int plugins_preinit  (void);
int plugins_init     (void);
int plugins_free     (void);
int plugins_update   (void);

int plugins_load     (const char * filename, const char * args);

int plugins_reg_sched(struct roard_plugins_sched * sched);
int plugins_reg_proto(struct roard_proto         * proto);

#define ROARD_DL_REG__UNI_PRE(name) \
 static int __reg_ ## name(struct roar_dl_librarypara * para, struct roar_dl_libraryinst * lib) { \
  size_t i; \
 \
  (void)para, (void)lib;

#define ROARD_DL_REG__UNI_POST \
 \
  return 0; \
 }

#define ROARD_DL_REG_SCHED(sched) \
 ROARD_DL_REG__UNI_PRE(sched) \
  for (i = 0; i < (sizeof((sched))/sizeof(*(sched))); i++) \
   plugins_reg_sched(&((sched)[i])); \
 ROARD_DL_REG__UNI_POST

// Register Scheduler callbacks:
#define ROARD_DL_REGFN_SCHED() ROAR_DL_PLUGIN_REG(ROAR_DL_FN_ROARDSCHED, __reg_sched)

#define ROARD_DL_REG_PROTO(proto) \
 ROARD_DL_REG__UNI_PRE(proto) \
  for (i = 0; i < (sizeof((proto))/sizeof(*(proto))); i++) \
   plugins_reg_proto(&((proto)[i])); \
 ROARD_DL_REG__UNI_POST

// Register Protocol callbacks:
#define ROARD_DL_REGFN_PROTO() ROAR_DL_PLUGIN_REG(ROAR_DL_FN_PROTO, __reg_proto)

// Check version:
#define ROARD_DL_CHECK_VERSIONS() ROAR_DL_PLUGIN_CHECK_VERSIONS(ROARD_DL_APPNAME, ROARD_DL_ABIVERSION)

#endif

//ll
