//uuid.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

int roar_uuid_eq(roar_uuid_t a, roar_uuid_t b) {
 if ( a == NULL || b == NULL ) {
  roar_err_set(ROAR_ERROR_FAULT);
  return -1;
 }

 if ( memcpy(a, b, sizeof(roar_uuid_t)) == 0 )
  return 1;

 return 0;
}

int roar_uuid2str(char * str, roar_uuid_t uuid, ssize_t len) {
 if ( str == NULL || uuid == NULL ) {
  roar_err_set(ROAR_ERROR_FAULT);
  return -1;
 }

 if ( len < 1 ) {
  roar_err_set(ROAR_ERROR_NOSPC);
  return -1;
 }

 snprintf(str, len, "%.2x%.2x%.2x%.2x-%.2x%.2x-%.2x%.2x-%.2x%.2x-%.2x%.2x%.2x%.2x%.2x%.2x",
          uuid[0], uuid[1], uuid[2], uuid[3], uuid[4], uuid[5], uuid[6], uuid[7],
          uuid[8], uuid[9], uuid[10], uuid[11], uuid[12], uuid[13], uuid[14], uuid[15]
         );

 return 0;
}

int roar_str2uuid(roar_uuid_t uuid, const char * str) {
 unsigned int inbuf[16];
 int i;

 if ( sscanf(str, "%2x%2x%2x%2x-%2x%2x-%2x%2x-%2x%2x-%2x%2x%2x%2x%2x%2x",
             &(inbuf[0]), &(inbuf[1]), &(inbuf[2]), &(inbuf[3]), &(inbuf[4]), &(inbuf[5]),
             &(inbuf[6]), &(inbuf[7]), &(inbuf[8]), &(inbuf[9]), &(inbuf[10]), &(inbuf[11]),
             &(inbuf[12]), &(inbuf[13]), &(inbuf[14]), &(inbuf[15])) != 16 ) {
  roar_err_set(ROAR_ERROR_ILLSEQ);
  return -1;
 }

 for (i = 0; i < 16; i++)
  uuid[i] = inbuf[i];

 return 0;
}
int roar_uuid_gen(roar_uuid_t uuid, enum roar_uuid_type type, roar_uuid_t ns, void * argp, ssize_t arglen) {
 if ( uuid == NULL ) {
  roar_err_set(ROAR_ERROR_FAULT);
  return -1;
 }

 switch (type) {
  case ROAR_UUID_TYPE_NULL:
    memset(uuid, 0, sizeof(roar_uuid_t));
    return 0;
   break;
  case ROAR_UUID_TYPE_RANDOM:
     roar_random_gen_nonce(uuid, sizeof(roar_uuid_t));
     uuid[6] = (uuid[8] & 0x0F) | 0x40; // Version
     uuid[8] = (uuid[8] & 0x3F) | 0x80; // Variant
    return 0;
   break;
  case ROAR_UUID_TYPE_DCE_SECURITY:
  case ROAR_UUID_TYPE_MD5:
  case ROAR_UUID_TYPE_SHA1:
    roar_err_set(ROAR_ERROR_NOTSUP);
    return -1;
   break;
 }

 roar_err_set(ROAR_ERROR_BADRQC);
 return -1;
}

//ll
