// globals
php

function calculate () {
	type = getValue ("format");
	file = getValue ("file");

	if (type == "gs" ) {
		gstype = getValue ("gsformat");
		if (gstype == "other") gstype = getValue ("gs_specifiedformat");
	} else {
		jpegpng = ((type == "jpeg") | (type == "png"));
		eps = (type == "postscript") && (getValue ("formateps"));

		
		
		if (getValue ("autoextension")) {
			if (type == "jpeg") {
				if (!( ereg("\.jpeg$",file)|ereg("\.jpg$",file) )) file += ".jpg";
			} elseif (type == "postscript") {
				if (eps) {
					if (!( ereg("\.ps$",file)|ereg("\.eps$",file) )) file += ".eps";
				} else {
					if (!( ereg("\.ps$",file)|ereg("\.eps$",file) )) file += ".ps";
				}
			} else {
				ext = "." + type;
				if (!ereg(ext+"$",file)) file += ext;
			}
		}
	}
	options = "";
	if ((type == "postscript") && eps) options += ", onefile=FALSE";

	
	if (jpegpng || (type == "gs")) {
		autores = getValue ("autores");
		if (autores) {
			if (jpegpng) resolution = 96;
			else resolution = 72;
		}	else resolution = getValue ("resolution");
	}

	autoW = getValue ("autowidth");	autoH = getValue ("autoheight");

	
	
	if (jpegpng && autoW && autoH) options += ", width=par(\"din\")[1]*" + resolution;
	elseif (jpegpng) {
		if(!autoW) options += ", width=" + round(getValue ("width")*resolution);
		if(!autoH) options += ", height=" + round(getValue ("height")*resolution);
	}	else {
		if(!autoW) options += ", width=" + getValue ("width");
		if(!autoH) options += ", height=" + getValue ("height");
	}

	
	if (!getValue ("autopointsize")) options += ", pointsize=" + getValue ("pointsize");
	if ((jpegpng && !autores)	|| (type == "gs"))  options += ", res=" + resolution;
	if ((type == "jpeg") && (!getValue ("autoquality"))) options += ", quality=" + getValue ("quality");

	
	if (!jpegpng) {
		if (!(eps)) paper = getValue ("paper");
		else paper = "special";
		if (!empty (paper)) options += ", paper=" + "\"" + paper + "\"";

		pagecentre = getValue ("pagecentre");
		if (!pagecentre) options += ", pagecentre=FALSE";

		if (!eps) pshoriz = getValue ("ps_horiz");
		else pshoriz = false;
		if (!pshoriz) options += ", horizontal=FALSE";

		family = getValue ("family");
		if (!empty(family)) options += ", family=" + "\"" + family + "\"";

		enc = getValue ("encoding");
		if (!empty(enc)) options += ", encoding=" + "\"" + enc + "\"";

		if (!getValue("autotitle")) options += ", title=" + "\"" + getValue("title") + "\"";
	}

echo ('dev.set (' + getValue ("devnum") + ')\n');
if (type == "gs") {
echo ('dev2bitmap ("' + file + '", type="' + gstype + '"' + options + ');\n');
} else {
echo ('dev.print (device=' + type + ', file="' + file + '"' + options + ');\n');
}
}

