// globals

function preprocess () {
  

echo ('  require(ltm)\n');
}

function calculate () {
  
  constraint   = getValue("constraint");
  startval     = getValue("startval");
  startval_mtx = getValue("startval_mtx");
  naaction     = getValue("naaction");
  irtparam     = getValue("irtparam");
  optimeth     = getValue("optimeth");
  verbose      = getValue("verbose");
  
  ghk_rasch    = getValue("ghk_rasch");
  iterqn_rasch = getValue("iterqn_rasch");

  
  
  control = array() ;
  if(iterqn_rasch != "150")
    control[] = "iter.qN="+iterqn_rasch ;
  if(ghk_rasch != "21")
    control[] = "GHk="+ghk_rasch ;
  if(optimeth != "BFGS")
    control[] = "method=\""+optimeth+"\"" ;
  if(verbose == "TRUE")
    control[] = "verbose=TRUE" ;

echo ('estimates.rasch <<- rasch(' + getValue("x"));
                  
                  if(constraint) echo (", constraint="+constraint);
                  if(irtparam != "TRUE") echo (", IRT.param=FALSE");
                  if(startval == "random") echo (", start.val=\"random\"");
                  if(startval == "matrix") echo (", start.val="+startval_mtx);
                  if(naaction) echo (", na.action="+naaction);
                  
                  if(control) echo (", control=list("+join(", ", control)+")");
 echo (')\n');
}

function printout () {
echo ('rk.header ("Rasch parameter estimation")\n');
echo ('rk.print (estimates.rasch$coefficients)\n');
}
