/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "RipOffTrack.h"

RipOffTrack ripoff_track_new()
{
	RipOffTrack new = g_new(struct RipOffTrack_, 1);

	new->album_title_string = g_malloc(strlen("Unknown Album")+1);
	new->artist_string = g_malloc(strlen("Unknown Artist")+1);
	new->genre_string = g_malloc(strlen("Misc")+1);

/* this needs to be changed to acquire the current year*/
	new->year_string = g_malloc(strlen("year")+1); 
	new->track_title = g_malloc(strlen("Unknown Track")+1);

	strncpy(new->album_title_string, "Unknown Album", strlen("Unknown Album")+1);
	strncpy(new->artist_string, "Unknown Artist", strlen("Unknown Artist")+1);
	strncpy(new->genre_string, "Misc", strlen("Misc")+1);
	strncpy(new->year_string, "year", strlen("year")+1);
	strncpy(new->track_title, "Unknown Track", strlen("Unknown Track")+1);

	new->track_number = -1;
	new->total_tracks = -1;

	return new;
}

gchar* ripoff_track_get_album_title(RipOffTrack track)
{
	int size = strlen(track->album_title_string)+1;
	gchar *string_copy = g_malloc(size);
	strncpy(string_copy, track->album_title_string, size);
	return string_copy;
}

gchar* ripoff_track_get_artist(RipOffTrack track)
{
	int size = strlen(track->artist_string)+1;
	gchar *string_copy = g_malloc(size);
	strncpy(string_copy, track->artist_string, size);
	return string_copy;
}

gchar* ripoff_track_get_genre(RipOffTrack track)
{
	int size = strlen(track->genre_string)+1;
	gchar *string_copy = g_malloc(size);
	strncpy(string_copy, track->genre_string, size);
	return string_copy;
}

gchar* ripoff_track_get_year(RipOffTrack track)
{
	int size = strlen(track->year_string)+1;
	gchar *string_copy = g_malloc(size);
	strncpy(string_copy, track->year_string, size+1);
	return string_copy;
}

gchar* ripoff_track_get_track_title(RipOffTrack track)
{
	int size = strlen(track->track_title)+1;
	gchar *string_copy = g_malloc(size);
	strncpy(string_copy, track->track_title, size);
	return string_copy;
}

gchar* ripoff_track_get_track_num_string(RipOffTrack track, gboolean leading_zero)
{
	gchar *num_string = g_malloc(4);

	if(track->track_number < 10 && leading_zero)
		g_snprintf(	num_string, 
				4, 
				"0%i", 
				track->track_number);
					  
	else
		g_snprintf(	num_string, 
				4, 
				"%i", 
				track->track_number);

	return num_string;
}

gint ripoff_track_get_track_num(RipOffTrack track)
{
	return track->track_number;
}

gint ripoff_track_get_total_tracks(RipOffTrack track)
{
	return track->total_tracks;
}

void ripoff_track_set_album_title(RipOffTrack track, gchar *album_string)
{
	gchar *buffer;
	gint length = strlen(album_string)+1;

	buffer = g_malloc(length);
	strncpy(buffer, album_string, length);

	g_free(track->album_title_string);

	track->album_title_string = buffer;
}

void ripoff_track_set_artist(RipOffTrack track, gchar *artist_string)
{
	gchar *buffer;
	gint length = strlen(artist_string)+1;

	buffer = g_malloc(length);
	strncpy(buffer, artist_string, length);

	g_free(track->artist_string);

	track->artist_string = buffer;
}

void ripoff_track_set_genre(RipOffTrack track, gchar *genre_string)
{
	gchar *buffer;
	gint length = strlen(genre_string)+1;

	buffer = g_malloc(length);
	strncpy(buffer, genre_string, length);

	g_free(track->genre_string);

	track->genre_string = buffer;
}

void ripoff_track_set_year(RipOffTrack track, gchar *year_string)
{
	gchar *buffer;
	gint length = strlen(year_string)+1;

	buffer = g_malloc(length);
	strncpy(buffer, year_string, length);

	g_free(track->year_string);

	track->year_string = buffer;
}

void ripoff_track_set_track_title(RipOffTrack track, gchar *track_string)
{
	gchar *buffer;
	gint length = strlen(track_string)+1;

	buffer = g_malloc(length);
	strncpy(buffer, track_string, length);

	g_free(track->track_title);

	track->track_title = buffer;
}

void ripoff_track_set_track_num(RipOffTrack track, gint track_number)
{
	track->track_number = track_number;
}

void ripoff_track_set_total_tracks(RipOffTrack track, gint total_tracks)
{
	track->total_tracks = total_tracks;
}

void ripoff_track_destroy(RipOffTrack track)
{
	g_free(track->album_title_string);
	g_free(track->artist_string);
	g_free(track->genre_string);
	g_free(track->year_string);
	g_free(track);
}
