# ifndef _RHEOLEF_EYE_H
# define _RHEOLEF_EYE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

# include "rheolef/vec.h"
namespace rheolef { 

/*Class:eye
NAME: @code{eye} - the identity matrix 
DESCRIPTION:       
  Following matlab, the name @code{eye()} is used in place of I to denote identity matrices
  because I is often used as a subscript or as sqrt(-1). The dimensions of @code{eye()} are
  determined by context.
  The preconditioner interface is usefull when calling algorithms without any
  preconditioners, e.g.
  @example
    int status = pcg (a, x, b, eye(), 100, 1e-7);
  @end example
AUTHOR: 
    Pierre Saramito
    | Pierre.Saramito@imag.fr
    LMC-IMAG, 38041 Grenoble cedex 9, France
DATE: 
    28 january 1997
End:
*/
//<eye:
class eye {
public:
  eye() {}
  template<class T> const vec<T>& operator* (const vec<T>& x) const { return x; }
  template<class T> const vec<T>& solve (const vec<T>& x) const { return x; }
  template<class T> const vec<T>& trans_solve (const vec<T>& x) const { x; }
};
//>eye:

// Remark: the shared libraries are sometime buggy
// and cannot initialize class constructor. So, do not define
// extern const eye<Float> EYE;

}// namespace rheolef
# endif // _RHEOLEF_EYE_H
