#ifndef _RHEO_EXACT_COMPOSE_H
#define _RHEO_EXACT_COMPOSE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
// --------------------------------------------------------------------
// exact_compose:
//  for use e.g. with riesz() or integrate()
// --------------------------------------------------------------------
#include "rheolef/riesz.h"
namespace rheolef { 
template <class Function, class Field>
struct exact_compose_type : std::unary_function<point,typename Function::result_type> {
  typedef point                            argument_type;
  typedef typename Function::result_type   result_type;
  typedef typename Function::argument_type median_type;
  exact_compose_type(Function f, const Field& uh) : _f(f), _uh(uh) {}
  result_type operator() (const point& x) const { return _f(_uh(x)); }
protected:
  Function _f;
  Field    _uh;
};
template <class Function, class Field>
inline
exact_compose_type<Function,Field>
exact_compose (Function f, const Field& uh)
{
  return exact_compose_type<Function,Field>(f,uh);
}
// full specialization for functions:
inline
exact_compose_type<std::pointer_to_unary_function<Float,Float>, field>
exact_compose (Float (*f)(Float), const field& uh)
{
  return exact_compose_type<std::pointer_to_unary_function<Float,Float>, field>(std::ptr_fun(f),uh);
}
inline
exact_compose_type<std::pointer_to_unary_function<const Float&,Float>, field>
exact_compose (Float (*f)(const Float&), const field& uh)
{
  return exact_compose_type<std::pointer_to_unary_function<const Float&,Float>, field>(std::ptr_fun(f),uh);
}
#ifdef TODO
// vector case:
inline
exact_compose_type<std::pointer_to_unary_function<point,Float>, vector_field>
exact_compose (Float (*f)(point), const field& uh)
{
  return exact_compose_type<std::pointer_to_unary_function<point,Float>, vector_field>(std::ptr_fun(f),vector_field(uh));
}
inline
exact_compose_type<std::pointer_to_unary_function<const point&,Float>, vector_field>
exact_compose (Float (*f)(const point&), const field& uh)
{
  return exact_compose_type<std::pointer_to_unary_function<const point&,Float>, vector_field>(std::ptr_fun(f),vector_field(uh));
}
// tensor case:
inline
exact_compose_type<std::pointer_to_unary_function<tensor,Float>, tensor_field>
exact_compose (Float (*f)(tensor), const field& uh)
{
  return exact_compose_type<std::pointer_to_unary_function<tensor,Float>, tensor_field>(std::ptr_fun(f),tensor_field(uh));
}
inline
exact_compose_type<std::pointer_to_unary_function<const tensor&,Float>, tensor_field>
exact_compose (Float (*f)(const tensor&), const field& uh)
{
  return exact_compose_type<std::pointer_to_unary_function<const tensor&,Float>, tensor_field>(std::ptr_fun(f),tensor_field(uh));
}
#endif // TODO
// --------------------------------------------------------------------
// difference
// --------------------------------------------------------------------
template <class Function1, class Function2>
struct difference_fun_type : std::unary_function<typename Function1::argument_type,typename Function1::result_type> {
  typedef typename Function1::argument_type  argument_type;
  typedef typename Function1::result_type    result_type;
  difference_fun_type(Function1 f1, Function2 f2) : _f1(f1), _f2(f2) {}
  result_type operator() (const point& x) const { return _f1(x) - _f2(x); }
protected:
  Function1 _f1;
  Function2 _f2;
};
template <class Function1, class Function2>
difference_fun_type<Function1,Function2>
difference_fun (Function1 f1, Function2 f2) {
 return difference_fun_type<Function1,Function2>(f1,f2);
}
}// namespace rheolef
#endif // _RHEO_EXACT_COMPOSE_H
