#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# --------------------------------------------------------------------------
#
# fld to bb (one component) field file format translator
#
# usage
#  awk -f fld2bb.awk < toto.fld > toto.bb
#
# see also : o  fld2ddl.awk and ddl2bb.awk for the multi-component field
#               and its conversion from (isolated component)fld
#               to bb format
#            o  bb2fld.awk for the reciprocal lconversion
#
BEGIN 	{
  I_S = N_S = 0 ;
  Opt = 0 ;
}

( ($1 == "field") || ($1=="") ) {
  next ;
}
/^#.*/ {
  next ;
}

(N_S == 0) {
  N_S = $2 ;
  next ;
}
(Opt < 2) {
  Opt++ ;
  next  ;
}
(I_S <= N_S) {
  V[I_S] = $1 ;
  I_S++ ;
  next ;
}

END	{
  print "2 1 " N_S " 2" ;
  for( i=0 ; i<=N_S ; i++ )
    print V[i] ;
}
