///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/vec_expr_ops.h"
#include "rheolef/diststream.h"
#include "rheolef/pretty_name.h"
using namespace rheolef;
using namespace std;

template <class Iterator>
void
check_iterator_access_raw (Iterator iter, size_t n) {
  warning_macro ("iter: expr.size="<<n);
  for (size_t i = 0; i < n; i++, iter++) {
    warning_macro ("iter: expr["<<i<<"] = "<<*iter);
  }
}
template <class Expr>
void
check_iterator_access (Expr e) {
  check_iterator_access_raw (e.begin(), e.size());
}  
template <class Expr>
void
check_subscript_access (Expr e) {
  warning_macro ("sub: expr.size="<<e.size());
  for (typename Expr::size_type i = 0, n = e.size(); i < n; i++) {
    warning_macro ("sub: expr["<<i<<"] = "<< e[i]);
  }
}
struct phi : unary_function<Float,Float> {
  Float operator() (const Float& x) { return 2*x; }
};
int main(int argc, char**argv) {
    environment distributed(argc, argv);
    size_t n = (argc < 2) ? 5 : atoi(argv[1]);
    vec<Float> x(n, 2.5);
    vec<Float> y(n, 4.);

    // set size and then assign:
    vec<Float> z(n); 
    z = 2*x - y;
    dcout << "z = 2*x-y : z.dis_size = " << z.dis_size() << endl;
    z.put_values (dcout);
    
    // size is zero and then assign:
    vec<Float> z1; 
    z1 = 2*x - y;
    dcout << "z1.dis_size = " << z1.dis_size() << endl;
    z1.put_values (dcout);
    
    // copy cstor:
    vec<Float> z2 = 2*x - y;
    dcout << "z2.dis_size = " << z2.dis_size() << endl;
    z2.put_values (dcout);

    check_iterator_access  (x+y);
    check_subscript_access (x+y);

    // dot with expression (lazy evaluation)
    dcout << "dot(x, z) = " << dot(x, z) << endl;
    dcout << "dot(x, 2*x-y) = " << dot(x, 2*x - y) << endl;
    dcout << "dot(2*x-y, x) = " << dot(2*x-y, x) << endl;
    dcout << "dot(3*x-y, 2*x-y) = " << dot(3*x-y, 2*x-y) << endl;

#ifdef TO_CLEAN    
    // set bad size and then assign: it may exit(1)
    vec<Float> z3(n+1); 
    z3 = 2*x - y;
    dcout << "z3 = " << z3.size() << endl;
    z3.put_values (dcout);
#endif // TO_CLEAN    
}
