///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#ifdef _RHEOLEF_HAVE_MPI
// Note: this file is recursively included by "polymorphic_array_mpi.cc" 
// with growing "N" and in the namespace "rheolef"
                                                                                             
/*F:
NAME: mpi_polymorphic_scatter_end -- gather/scatter finalize (@PACKAGE@ @VERSION@)
DESCRIPTION:
  Finishes communication
  for distributed to sequential scatter context.
AUTHORS:
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE:   23 march 1999
END:
*/

template <class Container, class Message, class Buffer>
struct mpi_polymorphic_scatter_end_t<Container,Message,Buffer,N> {
  void operator() (
    const Container&    x, // unused, just for the same profile with scatter_begin()
    Buffer&	        y,
    Message& 	        from,
    Message& 	        to,
    const communicator& comm) const
  {
    typedef typename Container::size_type size_type;
    const size_type _n_variant = N;

#define _RHEOLEF_typedef(z,k,unused)			\
    typedef typename Container::T##k T##k;
    BOOST_PP_REPEAT(N, _RHEOLEF_typedef, ~)
#undef _RHEOLEF_typedef

    typedef boost::transform_iterator<select2nd<size_t,mpi::request>, std::list<std::pair<size_t,mpi::request> >::iterator>
            request_iterator;
    // -----------------------------------------------------------
    // 1) wait on receives and unpack receives into local space
    // -----------------------------------------------------------
    y.resize (from.n_data());
#define _RHEOLEF_wait_recv(z,k,unused)                    			\
    while (from.requests[k].size() != 0) {					\
	typedef std::pair<size_type,T##k> data_type; /* the data to be received are of type Tk */ 	\
        request_iterator iter_r_waits (from.requests[k].begin(), select2nd<size_type,mpi::request>()),	\
                         last_r_waits (from.requests[k].end(),   select2nd<size_type,mpi::request>());	\
	/* waits on any receive... */									\
        std::pair<mpi::status,request_iterator> pair_status = mpi::wait_any (iter_r_waits, last_r_waits); \
	/* check status */								\
	boost::optional<int> ik_msg_size_opt = pair_status.first.template count<data_type>();	\
	check_macro (ik_msg_size_opt, "receive wait failed");				\
    	int iproc = pair_status.first.source();						\
	check_macro (iproc >= 0, "receive: source iproc = "<<iproc<<" < 0 !");		\
	/* get size of receive and number in data */					\
	size_type ik_msg_size = (size_type)ik_msg_size_opt.get();			\
        typename std::list<std::pair<size_type,mpi::request> >::iterator pair_ptr = pair_status.second.base(); \
        size_type i_recv = (*pair_ptr).first;						\
        check_macro (from.start_variant[i_recv+1][k] - from.start_variant[i_recv][k] == ik_msg_size, \
		"invalid received size "<<ik_msg_size << " while "			\
        	<< from.start_variant[i_recv+1][k] - from.start_variant[i_recv][k]	\
		<< " was expected");							\
        /* unpack receives into our local space: y[pair[jk].index] = pair[jk].value */	\
        for (size_type jk = from.start_variant[i_recv][k], mk = from.start_variant[i_recv+1][k]; jk < mk; jk++) {\
	    size_type  first_i = from.starts[i_recv];					\
	    size_type  iloc    = from.values._stack_##k [jk].first;			\
	    size_type  i       = from.values._stack_##k [jk].first + first_i;		\
	    const T##k value   = from.values._stack_##k [jk].second;			\
	    size_type  perm_i  = from.indices[i];						\
	    y[perm_i] = value;								\
        }										\
        from.requests[k].erase (pair_ptr);						\
    }
    BOOST_PP_REPEAT(N, _RHEOLEF_wait_recv, ~)
#undef _RHEOLEF_wait_recv

    // -----------------------------------------------------------
    // 2) wait on sends 
    // -----------------------------------------------------------
    for (size_type k = 0; k < _n_variant; k++) {
       request_iterator iter_s_waits (to.requests[k].begin(), select2nd<size_t,mpi::request>()),
                        last_s_waits (to.requests[k].end(),   select2nd<size_t,mpi::request>());
       mpi::wait_all (iter_s_waits, last_s_waits);
    }
  }
};
#endif // _RHEOLEF_HAVE_MPI
