///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/index_set.h"

namespace rheolef {

index_set::index_set (const index_set& x)
 : base()
{
  for (std::set<size_type>::const_iterator iter = x.base::begin(), last = x.base::end(); iter != last; iter++) {
    base::insert (*iter);
  }
}
index_set&
index_set::operator= (const index_set& x)
{
  base::clear();
  for (std::set<size_type>::const_iterator iter = x.base::begin(), last = x.base::end(); iter != last; iter++) {
    base::insert (*iter);
  }
  return *this;
}
index_set&
index_set::operator+= (const index_set& x)
{
  for (std::set<size_type>::const_iterator iter = x.base::begin(), last = x.base::end(); iter != last; iter++) {
    base::insert (*iter);
  }
  return *this;
}
std::istream&
operator>> (std::istream& is, index_set& x)
{
  typedef index_set::size_type size_type;
  size_type n;
  is >> n;
  x.clear();
  for (size_type i = 0; i < n; i++) {
    size_type xi;
    is >> xi;
    x.insert (xi);
  }
  return is;
}
std::ostream&
operator<< (std::ostream& os, const index_set& x)
{
  typedef index_set::size_type size_type;
  os << x.base::size() << "\t";	
  for (std::set<size_type>::const_iterator iter = x.base::begin(), last = x.base::end(); iter != last; iter++) {
    os << " " << *iter;	
  }
  return os;
}

} // namespace rheolef
