#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}

status=0

for d in 1 2 3; do
  command="../bin/mkgeo_grid_${d}d 10 -boundary | ../bin/geo -upgrade -geo - > mesh-${d}d.geo"
  echo "      $command"
  eval $command 2>/dev/null
  if test $? -ne 0; then status=1; echo "        => *NO*"; exit 1; fi
done

for d in 1 2 3; do
  for k in 1 2; do
    for p in eye ic0; do
        command="./ic0_tst mesh-${d}d P${k} ${p}"
        echo "      $command"
        eval $command >/dev/null 2>/dev/null
        if test $? -ne 0; then status=1; echo "        => *NO*"; fi
    done
  done
done

command="rm -f mesh-1d.geo mesh-2d.geo mesh-3d.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

exit $status
