#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float u_ex (const point& x) { return - 1./12 + (x[0]*(1-x[0]) + x[1]*(1-x[1]) + x[2]*(1-x[2]))/(2.*N); }
int main(int argc, char**argv) {
  environment distributed (argc, argv);
  Float error_l2_expected = (argc > 1) ? atof(argv[1]) : 4e-3;
  field uh;
  dcin >> uh;
  const space& Xh = uh.get_space();
  N = Xh.get_geo().dimension();
  field pi_h_u = interpolate(Xh, u_ex);
  form m (Xh, Xh, "mass");
  field one (Xh, 1.0);
warning_macro ("m(uh,1)     = " << m(uh,one));
warning_macro ("m(pi_h_u,1) = " << m(pi_h_u,one));
  Float error_l2 = sqrt(m(uh-pi_h_u,uh-pi_h_u));
  dcerr << "error_l2   = " << error_l2   << endl;
  return (error_l2 <= error_l2_expected) ? 0 : 1;
}
