#include "rheolef.h"
using namespace rheolef;
using namespace std;
Float u (const point& x) { return sin(x[0]+x[1]+x[2]); }
int main(int argc, char**argv) {
  environment distributed(argc, argv);
  field uh;
  dcin >> uh;
  Float error_l2_expected = (argc > 1) ? atof(argv[1]) : 1e-5;
  space Vh = uh.get_space();
  field pi_h_u = interpolate(Vh, u);
  field eh = pi_h_u - uh;
  form m(Vh, Vh, "mass");
  Float error_l2 = sqrt(m(eh,eh));
  dcout << "error_l2  "  << error_l2 << endl;
  return (error_l2 <= error_l2_expected) ? 0 : 1;
}
