#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#
# latex2html cannot handle complex figures
# with latex and postcript combined, so
# wrap arround this by generating a 
# .dvi for this figure, and then .ps
# then, include this file in a simple .fig
# and re-rrun fig2dev
#
# author: Pierre.Saramito@imag.fr
#
arg=$1
srcdir=$2
string=`expr ${arg} : '\(.*\).fig' \| ${arg}`
input=${string}.fig
here=`pwd`

name=`expr ${string} : '.*/\(.*\)' \| ${string}`
echo name $name
#exit 0
tmp="tmp"

fig2dev -L pstex                          ${input} > ${tmp}-1-${name}.ps
fig2dev -L pstex_t -p ${tmp}-1-${name}.ps ${input} > ${tmp}-1-${name}.tex

cat > ${tmp}-2-${name}.tex << EOF2
\documentclass{article}
\usepackage{epsfig}
\usepackage{color}
\begin{document}
\input{${tmp}-1-${name}.tex}
\thispagestyle{empty}
\end{document}
EOF2

latex ${tmp}-2-${name}.tex
dvips -E -f ${tmp}-2-${name}.dvi -o ${tmp}-2-${name}.ps
ps2epsi ${tmp}-2-${name}.ps ${tmp}-2-${name}.eps
epstopdf ${tmp}-2-${name}.eps
mv ${tmp}-2-${name}.pdf ${name}.pdf

/bin/rm -f tmp-1-${name}.tex
/bin/rm -f tmp-1-${name}.ps
/bin/rm -f tmp-2-${name}.tex 
/bin/rm -f tmp-2-${name}.aux
/bin/rm -f tmp-2-${name}.log
/bin/rm -f tmp-2-${name}.dvi
/bin/rm -f tmp-2-${name}.ps
/bin/rm -f tmp-2-${name}.eps

if test x"$srcdir" != x""; then
    here=`pwd`
    cd $srcdir
    dest=`pwd`
    cd $here
    if test $here != $dest; then
        command="mv ${name}.pdf $srcdir"
        echo $command
        eval $command
    fi
fi
