///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
# include "rheolef/array.h"
# include "rheolef/parstream.h"
# include "rheolef/par_inner_product.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv)
{
    environment parallel(argc, argv);
    array<Float> x(100, Float(2.0)/Float(3.0));
    Float norme2_x = par_inner_product (x.begin(),x.end(),x.begin(),x.comm()); 
    int ndigit;
    switch(sizeof(Float)) {
      case 16: ndigit = 20;
      case 8: 
      default: ndigit = 10;
    };
    cout.precision(ndigit);
    pcout << "dot(x,x) = " << norme2_x << endl;
    return 0;
}
