///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test d'un tableau polymorphe : affectations et acces indexes
//
#include "geo_element_tst.h"
#include "rheolef/polymorphic_array.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv) {
    environment parallel (argc, argv);
    string head;
    size_t n = 5;
    typedef polymorphic_traits<geo_element>::derived_type derived_type;
    const size_t n_derived = polymorphic_traits<geo_element>::n_derived;
    polymorphic_array_seq_rep <geo_element, derived_type, n_derived>   omega (n);

    // init a mesh:
    warning_macro ("STEP 1: insert...")
    omega[0] = geo_element_t (1,2,31);
    omega[1] = geo_element_t (5,7,9);
    omega[2] = geo_element_t (4,5,6);
    omega[3] = geo_element_q (15,16,17,18);
    omega[4] = geo_element_t (7,8,9);
    // modify the mesh:
    warning_macro ("STEP 2: modify...")
    omega[0] = geo_element_t (1,2,3);
    omega[1] = geo_element_T (11,12,13,14);
    pcout << "geo " << omega.size() << endl;
    for (size_t i = 0, n = omega.size(); i < n; i++) {
      cout << omega[i] << endl;
    }
};
