///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test d'un tableau polymorphe 
//
#include "rheolef/config.h"
#ifndef _RHEOLEF_HAVE_MPI
int main() { return 0; }
#else // _RHEOLEF_HAVE_MPI

#include "rheolef/polymorphic_map.h"
#include "rheolef/polymorphic_array.h"
#include "geo_element_tst.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv) {
    environment parallel (argc, argv);
    mpi::communicator comm;
    string head;
    size_t n;
    pcin >> head >> n;
    distributor ownership (n);
    polymorphic_array <geo_element>   elts (ownership);
    elts.get (pcin);
    if (comm.size() == 2 || comm.size() == 3) {
      set<size_t> ext_idx_set;
      switch (comm.rank()) {
       case 0:
		ext_idx_set.insert (3);
		ext_idx_set.insert (5);
		break;
       case 1:
		ext_idx_set.insert (0);
		ext_idx_set.insert (1);
		break;
       case 2:
		ext_idx_set.insert (0);
		ext_idx_set.insert (3);
		break;
       default: error_macro ("unsupported np >= 4");
      }
      polymorphic_map <geo_element>  ext_idx_map;
      elts.scatter (ext_idx_set, ext_idx_map);
      ext_idx_map.put (pcout);
    }
#ifdef TO_CLEAN
    pcout << "geo " << elts.par_size() << endl;
    elts.put (pcout);
#endif // TO_CLEAN
}
#endif // _RHEOLEF_HAVE_MPI
