///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float f (const point& x) { return 1+(0.5/N)*(x[0]*(1-x[0])+x[1]*(1-x[1])+x[2]*(1-x[2])); }
Float g (const point& x) { return -0.5/N; }
int main(int argc, char**argv) {
  environment parallel(argc, argv);
warning_macro ("neumann[1]");
  geo omega (argv[1]);
warning_macro ("neumann[2]");
  N = omega.dimension();
warning_macro ("neumann[3]");
  space Vh (omega, "P1");
warning_macro ("neumann[4]");
  field fh = interpolate(Vh, f);
warning_macro ("neumann[5]");
  field uh (Vh, 0.);
warning_macro ("neumann[6]");
  form m (Vh, Vh, "mass");
warning_macro ("neumann[7]");
  form a (Vh, Vh, "grad_grad");
warning_macro ("neumann[8]");
  form c = m+a;
warning_macro ("neumann[9]");
  size_t max_iter = 10000;
  Float tol = 1e-15;
warning_macro ("neumann[10]");
  int status = pcg (c.uu(), uh.u(), m.uu()*fh.u() + m.ub()*fh.b(), eye<Float>(), max_iter, tol, &pcerr);
warning_macro ("neumann[11]");
  pcout << uh;
warning_macro ("neumann[12]");
}
