#ifndef _RHEOLEF_MASS_H
#define _RHEOLEF_MASS_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/form_element.h"

namespace rheolef { 

template<class T>
class mass: public form_element_rep<T> {
public:
    typedef typename form_element_rep<T>::size_type size_type;

    mass (const element<T>& X, const element<T>& Y, const geo_basic<T>& omega)
	: form_element_rep<T> (X,Y,omega) { this->initialize_all(); }

    void operator() (const geo_element& K, ublas::matrix<T>& m) const;
    void initialize ();
};

}// namespace rheolef
#endif // _RHEOLEF_MASS_H
