#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# --------------------------------------------------------------------------
.SUFFIXES: .cc .ppf .m4 .fig .tex .dvi .ps .html .txt \
	.1 .2 .3 .4. .5 .6 .7 .8 .9 \
	.pdf .ctex .0texi .1texi .2texi .3texi .4texi \
	.5texi .6texi .7texi .8texi .9texi .flex


# shell+perl script that extract unix manual from sources:
SRC2MAN  = ${COL} -b -x | ${top_builddir}/config/doc2man -package ${PACKAGE} -version ${VERSION}
SRC2TEXI = ${COL} -b -x | ${top_builddir}/config/doc2texi

# usage: mkdoc.sh PERL PLDOC PACKAGE VERSION basename mansec inputfile
%.1: %.cc ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 1 > $@
%.1: % ${top_builddir}/config/doc2man
	grep -e '^#' < $< | sed -e 's/^#//' | ${SRC2MAN} -name $* -section 1 > $@
%.3: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 3 > $@
%.3: %.m4 ${top_builddir}/config/doc2man
	grep '^dnl[ 	][ 	]*#' $< | \
	    sed -e 's/^dnl[ 	][ 	]*//' -e 's/^#//' | \
	    ${SRC2MAN} -name $* -section 3 > $@
%.5: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 5 > $@
%.7: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 7 > $@
%.9: % ${top_builddir}/config/doc2man
	grep -e '^#' < $< | sed -e 's/^#//' | ${SRC2MAN} -name $* -section 9 > $@
%.9: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 9 > $@
%.9: %.m4 ${top_builddir}/config/doc2man
	grep '^dnl[ 	][ 	]*#' $< | \
	    sed -e 's/^dnl[ 	][ 	]*//' -e 's/^#//' | \
	    ${SRC2MAN} -name $* -section 9 > $@
%.9: %.icc ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 9 > $@

# the same with "rheolef" manpage suffix: e.g. point.h -> point.3rheolef
%.1rheolef: %.cc ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 1rheolef > $@
%.1rheolef: % ${top_builddir}/config/doc2man
	grep -e '^#' < $< | sed -e 's/^#//' | ${SRC2MAN} -name $* -section 1rheolef > $@
%.3rheolef: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 3rheolef > $@
%.3rheolef: %.m4 ${top_builddir}/config/doc2man
	grep '^dnl[ 	][ 	]*#' $< | \
	    sed -e 's/^dnl[ 	][ 	]*//' -e 's/^#//' | \
	    ${SRC2MAN} -name $* -section 3rheolef > $@
%.5rheolef: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 5rheolef > $@
%.7rheolef: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 7rheolef > $@
%.9rheolef: % ${top_builddir}/config/doc2man
	grep -e '^#' < $< | sed -e 's/^#//' | ${SRC2MAN} -name $* -section 9rheolef > $@
%.9rheolef: %.h ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 9rheolef > $@
%.9rheolef: %.icc ${top_builddir}/config/doc2man
	cat $< | ${SRC2MAN} -name $* -section 9rheolef > $@
%.9rheolef: %.m4 ${top_builddir}/config/doc2man
	grep '^dnl[ 	][ 	]*#' $< | \
	    sed -e 's/^dnl[ 	][ 	]*//' -e 's/^#//' | \
	    ${SRC2MAN} -name $* -section 9rheolef > $@

# DIR_PREFIX = `/bin/sh ${top_srcdir}/config/dir_prefix.sh ${top_builddir}`
DIR_PREFIX = ${subdir}/

%.0texi: %.cc ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< > $@
%.1texi: %.cc ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* command,,, Commands" > $@
%.1texi: % ${top_builddir}/config/doc2texi
	grep -e '^#' < $< | sed -e 's/^#//' | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* command,,, Commands" > $@
%.3texi: %.h ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* class,,, Classes" > $@
%.3texi: %.m4 ${top_builddir}/config/doc2texi
	grep '^dnl[ 	][ 	]*#' $< | \
	    sed -e 's/^dnl[ 	][ 	]*//' -e 's/^#//' | \
	    ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* class,,, Classes" > $@
%.5texi: %.h ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* algorithm,,, Algorithms" > $@
%.7texi: %.h ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* form,,, Forms" > $@
%.9texi: %.h ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* internal,,, Internals" > $@
%.9texi: %.icc ${top_builddir}/config/doc2texi
	cat $< | ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* internal,,, Internals" > $@
%.9texi: %.m4 ${top_builddir}/config/doc2texi
	grep '^dnl[ 	][ 	]*#' $< | \
	    sed -e 's/^dnl[ 	][ 	]*//' -e 's/^#//' | \
	    ${SRC2TEXI} -file ${DIR_PREFIX}$< -node "$* internal,,, Internals" > $@

${top_builddir}/config/doc2texi:
	cd ${top_builddir}/config; ${MAKE} doc2texi

${top_builddir}/config/doc2man:
	cd ${top_builddir}/config; ${MAKE} doc2man

.texi.txt:
	test x"${MAKEINFO}" != x"" \
	  && $(MAKEINFO) --no-header $<  > $*.txt

#.texi.dvi:
#	test x"${TEXI2DVI}" != x"" -a x"${TEX}" != x"" \
#          && TEXINPUTS=$(top_srcdir)/config/:$$TEXINPUTS \
#	     MAKEINFO='$(MAKEINFO) -I $(srcdir)' \
#	     $(TEXI2DVI) $<
#
#.texi.info:
#	test x"${MAKEINFO}" != x"" \
#	  && cd $(srcdir) \
#	  && rm -f $@ $@-[0-9] $@-[0-9][0-9] \
#	  && cd $(srcdir) \
#	  && $(MAKEINFO) `echo $< | sed 's,.*/,,'`
#
#.dvi.ps:
#	test x"${VIPS}" != x"" \
#	  && ${DVIPS} -t a4 `echo $< | sed 's,.*/,,'` -o $@

.ps.pdf:
	@if test x"${PS2PDF}" != x""; then \
	  echo "${PS2PDF} $*.ps $*.pdf";      \
	  ${PS2PDF} $*.ps $*.pdf;      \
	else 				  \
	  true;				  \
	fi

#.texi.html:
#	test x"${TEXI2HTML}" != x"" \
#	  && $(TEXI2HTML) $<

# flex rules
#$(srcdir)/%.cc: $(srcdir)/%.flex
#	@if test x"$(FLEX)" != x""; then \
#	    echo "$(FLEX) -t -+ -i $< | ${SHELL} ${top_srcdir}/config/flexfix.sh $(FLEXLEXER_H) > $(srcdir)/$*.cc"; \
#	    $(FLEX) -t -+ -i $< | ${SHELL} ${top_srcdir}/config/flexfix.sh $(FLEXLEXER_H) > $(srcdir)/$*.cc; \
#	else \
#	    test -f $@ && touch $@; \
#	fi
#
.flex.cc:
	@if test x"$(FLEX)" != x""; then \
	    echo "$(FLEX) -t -+ -i $< | ${SHELL} ${top_srcdir}/config/flexfix.sh $(FLEXLEXER_H) > $(srcdir)/$*.cc"; \
	    $(FLEX) -t -+ -i $< | ${SHELL} ${top_srcdir}/config/flexfix.sh $(FLEXLEXER_H) > $(srcdir)/$*.cc; \
	else \
	    test -f $@ && touch $@; \
	fi

# bison rule
$(srcdir)/%.cc: $(srcdir)/%.y
	@if [ x"$(BISON)" != x"" ]; then \
	    echo "$(BISON) -d $*.y -o ${srcdir}/$*.cc"; \
	    $(BISON) ${srcdir}/$*.y -o ${srcdir}/$*.cc; \
	else \
	  if test -f ${srcdir}/$*.cc; then \
	    echo "BISON: warning: "${srcdir}/$*.cc" not updated (BISON not available)."; \
	  else \
	    echo "BISON: error: "${srcdir}/$*.cc" not created (BISON not available)."; \
	    exit 1; \
	  fi \
	fi

# figures latex + postscript
%.pdf: %.fig
	@if test x"${FIG2DEV}" != x""; then				\
	    /bin/sh ${top_srcdir}/config/run_fig2dev.sh $*.fig ${srcdir};	\
	else								\
	    echo "warning: fig2dev missing";				\
	    echo "touch ${srcdir}/$*.pdf";				\
	    touch ${srcdir}/$*.pdf;					\
	fi
$(srcdir)/%.pdf: $(srcdir)/%.fig
	@if test x"${FIG2DEV}" != x""; then				\
	    /bin/sh ${top_srcdir}/config/run_fig2dev.sh $*.fig ${srcdir};	\
	else								\
	    echo "warning: fig2dev missing";				\
	    echo "touch ${srcdir}/$*.pdf";				\
	    touch ${srcdir}/$*.pdf;					\
	fi

# cd to srcdir to read data, and go back
# what's append when 2 compiles are concurrent ???
# handle also "terminal pslatex auxfile"
$(srcdir)/%.tex: $(srcdir)/%.plot
	@if test x"${GNUPLOT}" != x""; then				\
	    echo "cd ${srcdir}; $(GNUPLOT) `echo $< | sed 's,.*/,,'`";	\
	    cd ${srcdir}; $(GNUPLOT) `echo $< | sed 's,.*/,,'`;		\
	else								\
	    echo "warning: gnuplot missing";				\
	    echo "touch ${srcdir}/$*.tex ${srcdir}/$*.ps";		\
	    touch ${srcdir}/$*.tex ${srcdir}/$*.ps;			\
	fi
# psaux file, autopmatically gnerated by gnuplot

MKSYMLINK = /bin/sh ${top_srcdir}/config/mk-symlink.sh \
		${top_srcdir} \
		${top_builddir} \
		${srcdir}

${addprefix ${top_builddir}/include/rheolef/, ${pkginclude_HEADERS}}:
	$(MKSYMLINK) $(pkginclude_HEADERS)
${addprefix ${top_builddir}/include/rheolef/, ${machine_DATA}}:
	$(MKSYMLINK) $(machine_DATA)

