/*+++++++++++++++++++++++
noteshandler.h header file for noteshandler.c
markus@mhoenicka.de 2003-10-08
$Id: noteshandler.h,v 1.6.2.2 2005/09/21 23:30:31 mhoenicka Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ++++++++++++++++++++++++*/

struct addnotes_data {
  char year[5];
  char date_buffer[12];
  char real_key[256];
  char content_type[256];
  char content_xmllang[256];
  char user[DBUSER_LENGTH];
  char* msgpool;
  char* notepool;
  const char* drivername;
  int nmem_error; /* if != 0, out of memory error occurred */
  int ndb_error; /* if != 0, database error occurred */
  int n_skip; /* if != 0, skip current entry element */
  int depth; /* the current depth of the element stack */
  int depth_adjust; /* 0 if entry, 1 if ris */
  unsigned long long set_count; /* number of entry elements */
  unsigned long long added_count; /* number of added entry elements */
  unsigned long long skipped_count; /* number of skipped entries */
  unsigned long long updated_count; /* number of updated entry elements */
  unsigned long long failed_count; /* number of failed entry elements */
  int replace_note; /* if != 0, existing note is to be replaced */
  int create_new; /* if 1, dataset is a new one */
  size_t msgpool_len;
  size_t notepool_len;
  unsigned long long n_note_id; /* database id of dataset */
  unsigned long long n_user_id; /* database id of current user */
  int share; /* if 1, dataset is public; if 0, private */
  struct elstack* ptr_first; /* start of the element stack */
  struct CLIENT_REQUEST* ptr_clrequest;
  Lilid* ptr_id_sentinel; /* linked list for added IDs */
  dbi_conn conn;
  dbi_conn conn_refdb;
  dbi_driver driver;
  iconv_t conv_descriptor; /* conversion descriptor for iconv */
};

void notes_start_handler(void *ptr_data, const char *el, const char **ptr_attr);

void notes_end_handler(void *ptr_data, const char *el);

void notes_char_handler(void *ptr_data, const char *string, int len);
int insert_link(const char* type, const char* target, dbi_conn conn, unsigned long long n_note_id);
