/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsorganizationalunittester.h"

REGISTER_TEST(RdsOrganizationalUnitTester);


/**
creates structure:
dc=local
	dc=resara
		ou=testou
			cn=outestuser
			cn=outestgroup
		cn=Users
			cn=testuser
			cn=testgroup
*/
RdsOrganizationalUnitTester::RdsOrganizationalUnitTester(QObject *parent)
		: QObject(parent), m_ou()
{
}


RdsOrganizationalUnitTester::~RdsOrganizationalUnitTester()
{
}

void RdsOrganizationalUnitTester::initTestCase()
{
	rdsLdapSession()->remove("cn=testuser,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=testgroup,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=outestuser,ou=testou,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=outestgroup,ou=testou,dc=resara,dc=local");
	rdsLdapSession()->remove("ou=testou,dc=resara,dc=local");

	ReturnValue ret = TEST_FUNCTION(m_ou.createOu("testou"));
	QCOMPARE(ret.toString(), QString("OU=testou,DC=resara,DC=local"));
	ret = TEST_FUNCTION(m_ou.createUser("testuser", "testuseracct"));
	QCOMPARE(ret.toString(), QString("CN=testuser,CN=Users,DC=resara,DC=local"));
	ret = TEST_FUNCTION(m_ou.createGroup("testgroup"));
	QCOMPARE(ret.toString(), QString("CN=testgroup,CN=Users,DC=resara,DC=local"));

	RdsOrganizationalUnit ou("ou=testou,dc=resara,dc=local");
	ret = TEST_FUNCTION(ou.createUser("outestuser", "outestueracct"));
	QCOMPARE(ret.toString(), QString("CN=outestuser,ou=testou,dc=resara,dc=local"));
	ret = TEST_FUNCTION(ou.createGroup("outestgroup"));
	QCOMPARE(ret.toString(), QString("CN=outestgroup,ou=testou,dc=resara,dc=local"));
}

void RdsOrganizationalUnitTester::cleanupTestCase()
{
	TEST_FUNCTION(rdsLdapSession()->remove("cn=testuser,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(rdsLdapSession()->remove("cn=testgroup,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(rdsLdapSession()->remove("cn=outestuser,ou=testou,dc=resara,dc=local"));
	TEST_FUNCTION(rdsLdapSession()->remove("cn=outestgroup,ou=testou,dc=resara,dc=local"));
	TEST_FUNCTION(rdsLdapSession()->remove("ou=testou,dc=resara,dc=local"));
	rdsLdapSession()->remove("ou=ouTest,dc=resara,dc=local");
	rdsLdapSession()->remove("ou=test,dc=resara,dc=local");
}

void RdsOrganizationalUnitTester::constructorTest()
{
	RdsOrganizationalUnit ou(m_ou), ou2("ou=testou,dc=resara,dc=local");
	QCOMPARE(ou.dn(), m_ou.dn());

	RdsOrganizationalUnit testou1("ou=testou,dc=resara,dc=local"), testou2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << testou1;
	}
	{
		QDataStream stream(ar);
		stream >> testou2;
	}
	QCOMPARE(testou2.dn(), testou1.dn());
}

void RdsOrganizationalUnitTester::dnTest()
{
	ReturnValue ret = m_ou.dn();
	QCOMPARE(ret.toString(), QString("DC=resara,DC=local"));
	ret = m_ou.groupDn();
	QCOMPARE(ret.toString(), QString("CN=Users,DC=resara,DC=local"));
	ret = m_ou.userDn();
	QCOMPARE(ret.toString(), QString("CN=Users,DC=resara,DC=local"));
	ret = m_ou.computerDn();
	QCOMPARE(ret.toString(), QString("CN=Computers,DC=resara,DC=local"));

	RdsOrganizationalUnit ou("ou=testou,dc=resara,dc=local");
	ret = ou.dn();
	QCOMPARE(ret.toString(), QString("ou=testou,dc=resara,dc=local"));
	ret = ou.groupDn();
	QCOMPARE(ret.toString(), QString("ou=testou,dc=resara,dc=local"));
	ret = ou.userDn();
	QCOMPARE(ret.toString(), QString("ou=testou,dc=resara,dc=local"));
	ret = ou.computerDn();
	QCOMPARE(ret.toString(), QString("ou=testou,dc=resara,dc=local"));
}

void RdsOrganizationalUnitTester::listTest()
{
	///test base ou
	ReturnValue ret = TEST_FUNCTION(m_ou.listOus());
	QStringList list = ret.toStringList();
// 	qDebug() << list.size();
// 	foreach(QString dn, list)
// 		qDebug() << dn;
	QVERIFY(list.contains("OU=testou,DC=resara,DC=local"));

	ret = TEST_FUNCTION(m_ou.listUsers());
	list = ret.toStringList();
// 	qDebug() << list.size();
// 	foreach(QString dn, list)
// 		qDebug() << dn;
	QVERIFY(list.contains("CN=testuser,CN=Users,DC=resara,DC=local"));

	ret = TEST_FUNCTION(m_ou.listGroups());
	list = ret.toStringList();
// 	qDebug() << list.size();
// 	foreach(QString dn, list)
// 		qDebug() << dn;
	QVERIFY(list.contains("CN=testgroup,CN=Users,DC=resara,DC=local"));

	ret = TEST_FUNCTION(m_ou.listComputers());
	list = ret.toStringList();
// 	qDebug() << list.size();
// 	foreach(QString dn, list)
// 		qDebug() << dn;
	///@note this was not added in this test.
	QVERIFY2(list.contains("CN=TESTXP,CN=Computers,DC=resara,DC=local"), "might have been removed from the directory");

	///test testou
	RdsOrganizationalUnit ou("ou=testou,dc=resara,dc=local");
	ret = TEST_FUNCTION(ou.listOus());
	list = ret.toStringList();
	QCOMPARE(list.size(), 0);

	ret = TEST_FUNCTION(ou.listUsers());
	list = ret.toStringList();
	QVERIFY(list.contains("CN=outestuser,OU=testou,DC=resara,DC=local"));

	ret = TEST_FUNCTION(ou.listGroups());
	list = ret.toStringList();
	QVERIFY(list.contains("CN=outestgroup,OU=testou,DC=resara,DC=local"));

	ret = TEST_FUNCTION(ou.listComputers());
	list = ret.toStringList();
	QCOMPARE(list.size(), 0);
}

void RdsOrganizationalUnitTester::ouTest()
{
	///createOu()
	ReturnValue ret = TEST_FUNCTION(m_ou.createOu("ouTest"));
	QCOMPARE(ret.toString(), QString("OU=ouTest,DC=resara,DC=local"));

	TEST_FUNCTION_ERROR(m_ou.createOu("ou=test,dc=resara,dc=local"));

	///ou()
	ret = TEST_FUNCTION_ERROR(m_ou.ou());

	RdsOrganizationalUnit ou("ou=ouTest,dc=resara,dc=local");
	ret = TEST_FUNCTION(ou.ou());
	QCOMPARE(ret.toString(), QString("ouTest"));

	///setOu()
	TEST_FUNCTION_ERROR(m_ou.setOu("break"));

	ret = TEST_FUNCTION(ou.setOu("test"));
	QCOMPARE(ret.toString(), QString("OU=test,dc=resara,dc=local"));
	QCOMPARE(ou.ou().toString(), QString("test"));

	///get/setDescription()
	TEST_FUNCTION(ou.setDescription("test description"));
	ret = TEST_FUNCTION(ou.description());
	QCOMPARE(ret.toString(), QString("test description"));
	TEST_FUNCTION(ou.setDescription(""));
	ret = TEST_FUNCTION(ou.description());
	QCOMPARE(ret.toString(), QString(""));

	///remove()
	TEST_FUNCTION(ou.remove());
	TEST_FUNCTION_ERROR(ou.ou());
	TEST_FUNCTION_ERROR(ou.remove());

	TEST_FUNCTION_ERROR(m_ou.remove());
}

