/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsgrouptester.h"

REGISTER_TEST(RdsGroupTester);

RdsGroupTester::RdsGroupTester(QObject *parent)
		: QObject(parent)
{
}


RdsGroupTester::~RdsGroupTester()
{
}

void RdsGroupTester::initTestCase()
{
	///add some users and groups to use
	rdsLdapSession()->remove("CN=differentCn,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testuser1,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testuser2,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup1,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup2,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup3,cn=Users,dc=resara,dc=local");

	RdsLdapActions act;
	act.add(RdsLdapActions::Add, "objectClass", "user");
	act.add(RdsLdapActions::Add, "cn", "testuser1");
	act.add(RdsLdapActions::Add, "sn", "testuser1");
	TEST_FUNCTION(rdsLdapSession()->add("CN=testuser1,cn=Users,dc=resara,dc=local", act));

	act.clear();
	act.add(RdsLdapActions::Add, "objectClass", "user");
	act.add(RdsLdapActions::Add, "cn", "testuser2");
	act.add(RdsLdapActions::Add, "sn", "testuser2");
	TEST_FUNCTION(rdsLdapSession()->add("CN=testuser2,cn=Users,dc=resara,dc=local", act));

	TEST_FUNCTION(RdsGroup::createGroup("CN=testgroup1,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(RdsGroup::createGroup("CN=testgroup2,cn=Users,dc=resara,dc=local"));
}

void RdsGroupTester::cleanupTestCase()
{
	///remove users and groups
	rdsLdapSession()->remove("CN=differentCn,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testuser1,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testuser2,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup1,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup2,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup3,cn=Users,dc=resara,dc=local");
}

void RdsGroupTester::constructorTest()
{
	RdsGroup group("CN=testgroup1,cn=Users,dc=resara,dc=local");
	RdsGroup group2(group), group3("CN=testgroup2,cn=Users,dc=resara,dc=local");

	QCOMPARE(group.dn(), group2.dn());

	RdsGroup testgroup1("CN=testgroup1,cn=Users,dc=resara,dc=local"), testgroup2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << testgroup1;
	}
	{
		QDataStream stream(ar);
		stream >> testgroup2;
	}
	QCOMPARE(testgroup2.dn(), testgroup1.dn());
}

void RdsGroupTester::cnTest()
{
	RdsGroup group("CN=testgroup1,cn=Users,dc=resara,dc=local");

	ReturnValue ret = TEST_FUNCTION(group.cn());
	QCOMPARE(ret.toString(), QString("testgroup1"));

	TEST_FUNCTION_ERROR(group.setCn("testgroup2"));
	ret = TEST_FUNCTION(group.setCn("differentCn"));
	QCOMPARE(ret.toString(), QString("CN=differentCn,cn=Users,dc=resara,dc=local"));

	TEST_FUNCTION(group.setCn("testgroup1"));
}

void RdsGroupTester::membersTest()
{
	RdsGroup group("CN=testgroup1,cn=Users,dc=resara,dc=local");
	ReturnValue ret = TEST_FUNCTION(group.members());
	QStringList list = ret.toStringList();
	QCOMPARE(list.size(), 0);

//	TEST_FUNCTION_ERROR(group.addMember("CN=testgroup1,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(group.addMember("CN=testuser1,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(group.addMember("CN=testuser2,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(group.addMember("CN=testgroup2,cn=Users,dc=resara,dc=local"));

	ret = TEST_FUNCTION(group.members());
	list = ret.toStringList();
	QCOMPARE(list.size(), 3);
	QVERIFY(list.contains("CN=testuser1,CN=Users,DC=resara,DC=local"));
	QVERIFY(list.contains("CN=testuser2,CN=Users,DC=resara,DC=local"));
	QVERIFY(list.contains("CN=testgroup2,CN=Users,DC=resara,DC=local"));

	TEST_FUNCTION(group.removeMember("CN=testuser1,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(group.removeMember("CN=testuser2,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(group.removeMember("CN=testgroup2,cn=Users,dc=resara,dc=local"));

	ret = TEST_FUNCTION(group.members());
	list = ret.toStringList();
	QCOMPARE(list.size(), 0);
}

void RdsGroupTester::groupTest()
{
	RdsGroup group("CN=testgroup1,cn=Users,dc=resara,dc=local");
	ReturnValue ret = TEST_FUNCTION(group.groups());
	QStringList list = ret.toStringList();
	QCOMPARE(list.size(), 0);

	TEST_FUNCTION(group.joinGroup("CN=testgroup2,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION_ERROR(group.joinGroup("CN=testuser1,cn=Users,dc=resara,dc=local"));

	ret = TEST_FUNCTION(group.groups());
	list = ret.toStringList();
	QCOMPARE(list.size(), 1);
	QVERIFY(list.contains("CN=testgroup2,CN=Users,DC=resara,DC=local"));

	TEST_FUNCTION(group.leaveGroup("CN=testgroup2,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION_ERROR(group.leaveGroup("CN=testuser1,cn=Users,dc=resara,dc=local"));

	ret = TEST_FUNCTION(group.groups());
	list = ret.toStringList();
	QCOMPARE(list.size(), 0);
}

void RdsGroupTester::getSetTest()
{
	RdsGroup group("CN=testgroup1,cn=Users,dc=resara,dc=local");

	///description
	TEST_FUNCTION(group.setDescription("this is a description"));
	ReturnValue ret = TEST_FUNCTION(group.description());
	QCOMPARE(ret.toByteArray(), QByteArray("this is a description"));

	TEST_FUNCTION(group.setDescription("this is another description"));
	ret = TEST_FUNCTION(group.description());
	QCOMPARE(ret.toByteArray(), QByteArray("this is another description"));

	TEST_FUNCTION(group.setDescription(""));
	ret = TEST_FUNCTION(group.description());
	QCOMPARE(ret.toByteArray(), QByteArray(""));

	///notes
	TEST_FUNCTION(group.setNotes("this is a note"));
	ret = TEST_FUNCTION(group.notes());
	QCOMPARE(ret.toString(), QString("this is a note"));

	TEST_FUNCTION(group.setNotes(""));
	TEST_FUNCTION_ERROR(group.notes());
}


void RdsGroupTester::createGroupTest()
{
	ReturnValue ret = TEST_FUNCTION(RdsGroup::createGroup("cn=testgroup3,cn=Users,dc=resara,dc=local"));
	QCOMPARE(ret.toString(), QString("cn=testgroup3,cn=Users,dc=resara,dc=local"));

	TEST_FUNCTION_ERROR(RdsGroup::createGroup("cn=testgroup3,cn=Users,dc=resara,dc=local"));

	rdsLdapSession()->remove("cn=testgroup3,cn=Users,dc=resara,dc=local");
}

