/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsadobjecttester.h"

REGISTER_TEST(RdsAdObjectTester);

RdsAdObjectTester::RdsAdObjectTester(QObject *parent)
		: QObject(parent)
{
}


RdsAdObjectTester::~RdsAdObjectTester()
{
}

void RdsAdObjectTester::initTestCase()
{
	rdsLdapSession()->remove("cn=adobjecttester,cn=Users,dc=resara,dc=local");

	RdsLdapActions act;
	act.add(RdsLdapActions::Add, "objectClass", "user");
	act.add(RdsLdapActions::Add, "cn", "adobjecttester");
	act.add(RdsLdapActions::Add, "sn", "adobjecttester");

	TEST_FUNCTION(rdsLdapSession()->add("cn=adobjecttester,cn=Users,dc=resara,dc=local", act));
}

void RdsAdObjectTester::cleanupTestCase()
{
	rdsLdapSession()->remove("cn=adobjecttester,cn=Users,dc=resara,dc=local");
}

void RdsAdObjectTester::constructorTest()
{
	RdsAdObject ado;
	RdsAdObject admino(ado);

	RdsAdObject testadobj1, testadobj2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << testadobj1;
	}
	{
		QDataStream stream(ar);
		stream >> testadobj2;
	}
	QCOMPARE(testadobj2.dn(), testadobj1.dn());
}

void RdsAdObjectTester::sidTest()
{
	RdsAdObject adobject;
	ReturnValue ret = TEST_FUNCTION(adobject.sid());
	RdsSid sid = ret.value<RdsSid>();
//	qDebug() << sid.toString();

	adobject.setDn("cn=adobjecttester,cn=Users,dc=resara,dc=local");
	TEST_FUNCTION_ERROR(adobject.setSid(sid));

	///not sure if this is a bad idea or not...
	//sid.setRid(rand()%rand());
	TEST_FUNCTION(adobject.setSid(sid));
}

void RdsAdObjectTester::securityDescriptorTest()
{
	RdsAdObject adobject;
	ReturnValue ret = TEST_FUNCTION(adobject.securityDescriptor());
	RdsNtSecurityDescriptor descriptor = ret.value<RdsNtSecurityDescriptor>();
//	qDebug() << descriptor.toString();

	adobject.setDn("cn=adobjecttester,cn=Users,dc=resara,dc=local");
	TEST_FUNCTION(adobject.setSecurityDescriptor(descriptor));
}

void RdsAdObjectTester::guidTest()
{
	RdsAdObject adobject;
	ReturnValue ret = TEST_FUNCTION(adobject.guid());
	RdsGuid guid = ret.value<RdsGuid>();
//	qDebug() << guid.toString();

	adobject.setDn("cn=adobjecttester,cn=Users,dc=resara,dc=local");
	TEST_FUNCTION_ERROR(adobject.setGuid(guid));

	///not sure if this is a bad idea or not...
	//guid.setTimeMiddle(rand()%rand());
	TEST_FUNCTION(adobject.setGuid(guid));
}



