/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSID_H
#define RDSSID_H

#include <QxtPimpl>
#include <QMetaType>
#include <QVariant>
#include <ReturnValue>
#include <rdsglobal.h>

class QString;
class RdsSidPrivate;
class QByteArray;
class RdsSid;

/**
	@author Chris Vickery <chris@resara.com>
*/

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsSid& sid);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsSid& sid);

class RDS_SHARED_EXPORT RdsSid
{
	QXT_DECLARE_PRIVATE(RdsSid);
        friend RDS_SHARED_EXPORT QDataStream& ::operator>> (QDataStream& d, RdsSid& sid);
        friend RDS_SHARED_EXPORT QDataStream& ::operator<< (QDataStream& d, const RdsSid& sid);
public:
	RdsSid();
	RdsSid(const QString &sid);
	RdsSid(const char *sid);
	RdsSid(const QByteArray &data);
	RdsSid(const RdsSid &other);
	~RdsSid();
	
	QString toString() const;
	QString toShortString() const;
	QByteArray toBinary() const;
	uchar version() const;
	void setVersion(uchar ver);
	unsigned long long authority() const;
	void setAuthority(unsigned long long auth);
	QList<uint> domain() const;
	void setDomain(QList<uint> dom);
	uint rid() const;
	void setRid(uint r);
	bool isNull() const;

	RdsSid& operator=(const RdsSid &other);
	RdsSid& operator=(const QString &str);
	bool operator==(const RdsSid &other) const;
	bool operator!=(const RdsSid &other) const;
	bool operator==(const QString &str) const;
	bool operator!=(const QString &str) const;
	inline operator QVariant() const
	{
		return(QVariant::fromValue(*this));
	}
	inline operator ReturnValue() const
	{
		return(QVariant::fromValue(*this));
	}
	
	static RdsSid getDomainSid();
};

RDS_SHARED_EXPORT QDebug operator<<(QDebug dbg, const RdsSid& sid);

Q_DECLARE_METATYPE(RdsSid);
Q_DECLARE_TYPEINFO(RdsSid, Q_MOVABLE_TYPE);

#endif
