/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSCHEDULE_P_H
#define RDSSCHEDULE_P_H

#include <QxtPimpl>
#include <QSharedData>
#include "rdsschedule.h"

/**
	@author Chris Vickery <chris@resara.com>
 */
class RdsScheduleData : public QSharedData
{
public:
	RdsScheduleData()
			: weekMask(RdsSchedule::Monday | RdsSchedule::Tuesday | RdsSchedule::Wednesday | RdsSchedule::Thursday | RdsSchedule::Friday | RdsSchedule::Saturday | RdsSchedule::Sunday),
			day(0)
	{
	}
	RdsSchedule::Type type;
	QTime time;
	RdsSchedule::WeekMask weekMask;
	int day;
};

class RdsSchedulePrivate : public QxtPrivate<RdsSchedule>
{
public:
	RdsSchedulePrivate()
			: data(new RdsScheduleData())
	{
	}
	QSharedDataPointer<RdsScheduleData> data;

	static RdsSchedule::Day convertDay(Qt::DayOfWeek day);
	static Qt::DayOfWeek convertDay(RdsSchedule::Day day);
};

#endif
