/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSCHEDULE_H
#define RDSSCHEDULE_H

#include <rdsglobal.h>
#include <QxtPimpl>
#include <QTime>
#include <QFlags>
#include <QMetaType>

class RdsSchedulePrivate;
class RdsSchedule;

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsSchedule& object);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsSchedule& object);

/**
	@author Chris Vickery <chris@resara.com>
 */
class RDS_SHARED_EXPORT RdsSchedule
{
	QXT_DECLARE_PRIVATE(RdsSchedule);
	friend RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsSchedule& object);
	friend RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsSchedule& object);
public:
	RdsSchedule();
	RdsSchedule(const RdsSchedule& other);
	~RdsSchedule();
	RdsSchedule& operator=(const RdsSchedule& other);
	enum Type
	{
		None,
		Daily,
		Weekly,
		Monthly
	};
	enum Day
	{
		Monday = 1 << 0,
		Tuesday = 1 << 1,
		Wednesday  = 1 << 2,
		Thursday = 1 << 3,
		Friday = 1 << 4,
		Saturday = 1 << 5,
		Sunday = 1 << 6
	};
	Q_DECLARE_FLAGS(WeekMask, Day);

	Type type() const;
	void setType(Type type);
	QTime time() const;
	void setTime(const QTime& time);
	WeekMask weekMask() const;
	void setWeekMask(WeekMask mask);
	int day() const;
	void setDay(int day);
	QDateTime nextEvent() const;

	// Static initializers for common types
	static RdsSchedule daily(); // every night at midnight
	static RdsSchedule weekly(); // every saturday night at midnight
	static RdsSchedule monthly(); // the first of every month at midnight
};
Q_DECLARE_METATYPE(RdsSchedule);
Q_DECLARE_OPERATORS_FOR_FLAGS(RdsSchedule::WeekMask);

#endif

