/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSGUID_P_H
#define RDSGUID_P_H

#include <QxtPimpl>
#include "rdsguid.h"

#include <QSharedDataPointer>

#include <ReturnValue>

class RdsGuidData : public QSharedData
{
public:
	RdsGuidData()
			: isNull(true),
			timeLow(0),
			timeMiddle(0),
			timeHiAndVersion(0),
			clockSequence(0),
			node(0)
	{
	}
	bool isNull;
	quint32 timeLow;
	quint16 timeMiddle;
	quint16 timeHiAndVersion;
	quint16 clockSequence;
	quint64 node;
};

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsGuidPrivate : public QxtPrivate<RdsGuid>
{
public:
	RdsGuidPrivate()
	{
	}
	QSharedDataPointer<RdsGuidData> data;
	ReturnValue parseString(const QString &str);
	ReturnValue parseByteArray(const QByteArray &data);
};

#endif
