/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSGLOBAL_H_
#define RDSGLOBAL_H_

#include "config.h"
#include "rdsprotocolversion.h"

#ifdef RDS_CLIENT_LIB
#define RDS_CLIENT_EXPORT Q_DECL_EXPORT
#define RDS_SHARED_EXPORT Q_DECL_EXPORT
#else
#define RDS_CLIENT_EXPORT Q_DECL_IMPORT
#define RDS_SHARED_EXPORT Q_DECL_IMPORT
#endif
#ifndef Q_OS_WIN32
#include <stdlib.h>
#endif
#include <QString>
#include <QFile>
#include <QRegExp>
#include <QUrl>
#include <QDir>
#include <QCoreApplication>
#ifdef __RDS_SERVER
#include <RdsSettings>
#endif


inline QString rdsGetEnvPath(const char *name, QString defaultpath)
{
#ifndef Q_OS_WIN32
	const char *tmp = getenv(name);
	if (tmp != NULL) return(tmp);

#ifdef __RDS_SERVER
	QVariant value = rdssettings()->value(QString("Paths/") + name);
	if (!value.isNull()) return(value.toString());
#endif

	return(defaultpath);
#else
	Q_UNUSED(name);
	return(defaultpath);
#endif
}

inline QString getLdapUri(const char* name, const QString &str)
{
	QString ret = rdsGetEnvPath(name, str);
	if (ret.startsWith("ldapi://"))
	{
		ret = "ldapi://" + QString(QUrl::toPercentEncoding(ret.mid(8)));
	}
	return ret;
}

inline QString findRdsIcon(const QString &p)
{
#ifdef Q_WS_MAC
	QDir dir = QDir(QCoreApplication::applicationDirPath());
	dir.cdUp();
	QString bundlepath = dir.path() + "/Resources/" + p;

	if (QFile::exists(bundlepath))
                return bundlepath;
#endif
	if (QFile::exists(p))
		return p;
	QString pathtemplate = p;
	pathtemplate = pathtemplate.remove(QRegExp("^.*icons/")).prepend("%1/");

	QString path = pathtemplate.arg(RDS_DATA_PATH + "/icons/");
	if (QFile::exists(path))
		return path;

	return QString();
}


template<typename T>
inline T returnByType(const T &val, const char* buffer)
{
	Q_UNUSED(val);
	return *(T*)buffer;
}

template<typename T>
inline QList<T> reverseList(const QList<T> &list)
{
	QList<T> ret;
	for (typename QList<T>::const_iterator i = list.begin(); i != list.end(); ++i)
	{
		ret.prepend(*i);
	}
	return ret;
}

#define VERIFY_VALUES(x) \
	if(qxt_d().data->x != other.qxt_d().data->x) \
	{\
		/*  \
		qWarning() << "Value of" << #x << "do not match:" << qxt_d().data->x << other.qxt_d().data->x;\
		*/ \
		return false;\
	}

#define VERIFY_VALUES_ARRAY(x, size) \
	for(int i = 0; i < size; ++i)\
	{\
		if(qxt_d().data->x[i] != other.qxt_d().data->x[i]) \
		{\
			/* \
			qWarning() << "Value of" << #x << "[" << i << "] do not match:" << qxt_d().data->x[i] << other.qxt_d().data->x[i];\
			*/ \
			return false;\
		}\
	}

#define SHOW_HEX_FOR(val)\
	qDebug() << #val << data.mid(offset - dataPtr, sizeof(val)).toHex().rightJustified(sizeof(val)*2, '0');

#define SHOW_INT_VALUE(x)\
	qDebug() << #x << QString::number(x, 16).rightJustified(sizeof(x)*2, '0');

#define INT_AS_HEX(x) QString::number(x, 16).rightJustified(sizeof(x)*2, '0')
#define INT_AS_HEX_SIZE(x, size) QString::number(x, 16).rightJustified(size*2, '0')

#ifdef NT_SEC_DEBUG
#warning NT_SEC_DEBUG is set
#define READ_INT_VALUE(name, offset)\
	if((qint32)((offset - dataPtr) + sizeof(name)) > data.count())\
		return ReturnValue(1, "Data is not large enough to read " #name);\
	SHOW_HEX_FOR(name);\
	name = (sizeof(name) == 1 ? returnByType(name, offset) : qFromLittleEndian(returnByType(name, offset)));\
	offset += sizeof(name);\
	SHOW_INT_VALUE(name);

#define READ_INT_VALUE_BIGENDIAN(name, offset)\
	if((qint32)((offset - dataPtr) + sizeof(name)) > data.count())\
		return ReturnValue(1, "Data is not large enough to read " #name);\
	SHOW_HEX_FOR(name);\
	name = (sizeof(name) == 1 ? returnByType(name, offset) : qFromBigEndian(returnByType(name, offset)));\
	SHOW_HEX_FOR(name);\
	offset += sizeof(name);\
	SHOW_INT_VALUE(name);

#else

#define READ_INT_VALUE(name, offset)\
	if((qint32)((offset - dataPtr) + sizeof(name)) > data.count())\
		return ReturnValue(1, "Data is not large enough to read " #name);\
	name = (sizeof(name) == 1 ? returnByType(name, offset) : qFromLittleEndian(returnByType(name, offset)));\
	offset += sizeof(name);

#define READ_INT_VALUE_BIGENDIAN(name, offset)\
	if((qint32)((offset - dataPtr) + sizeof(name)) > data.count())\
		return ReturnValue(1, "Data is not large enough to read " #name);\
	name = (sizeof(name) == 1 ? returnByType(name, offset) : qFromBigEndian(returnByType(name, offset)));\
	offset += sizeof(name);

#endif

#define READ_INT_VALUE_SIZE(name, offset, size)\
	if((qint32)((offset - dataPtr) + size) > data.count())\
		return ReturnValue(1, "Data is not large enough to read " #name);\
	memcpy(&name, offset, size);\
	name = qFromLittleEndian(name);\
	offset += size;

#define READ_INT_VALUE_SIZE_BIGENDIAN(name, offset, size)\
	if((qint32)((offset - dataPtr) + size) > data.count())\
		return ReturnValue(1, "Data is not large enough to read " #name);\
	memcpy(&name, offset, size);\
	name = (qFromBigEndian(name) >> ((sizeof(name)) - size) * 8);\
	offset += size;

#define READ_INT_FROM_STRING(x, str)\
	x = returnByType(x, QByteArray::fromHex(str.mid(offset,sizeof(x)*2).toAscii()).constData());\
	if(sizeof(x) > 1)\
		x = qFromBigEndian(x);\
	offset += sizeof(x)*2;

#define READ_INT_FROM_STRING_SIZE(x, str, size)\
	x = returnByType(x, QByteArray::fromHex(str.mid(offset,size*2).toAscii()).constData());\
	if(size > 1)\
		x = qFromBigEndian(x);\
	x = x >> ((sizeof(x) - size)*8);\
	offset += size*2;

#endif //#ifndef RDSGLOBAL_H_
