/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsglobal.h"
#include <RdsDnsZone>
#include <QStringList>

RdsDnsZone::RecordType RdsDnsZone::stringToType(const QString &str)
{
	if (str == "A")
		return RdsDnsZone::A;
	if (str == "AAAA")
		return RdsDnsZone::AAAA;
	if (str == "AFSDB")
		return RdsDnsZone::AFSDB;
	if (str == "CERT")
		return RdsDnsZone::CERT;
	if (str == "CNAME")
		return RdsDnsZone::CNAME;
	if (str == "DHCID")
		return RdsDnsZone::DHCID;
	if (str == "DLV")
		return RdsDnsZone::DLV;
	if (str == "DNAME")
		return RdsDnsZone::DNAME;
	if (str == "DNSKEY")
		return RdsDnsZone::DNSKEY;
	if (str == "DS")
		return RdsDnsZone::DS;
	if (str == "HIP")
		return RdsDnsZone::HIP;
	if (str == "IPSECKEY")
		return RdsDnsZone::IPSECKEY;
	if (str == "KEY")
		return RdsDnsZone::KEY;
	if (str == "LOC")
		return RdsDnsZone::LOC;
	if (str == "MX")
		return RdsDnsZone::MX;
	if (str == "NAPTR")
		return RdsDnsZone::NAPTR;
	if (str == "NS")
		return RdsDnsZone::NS;
	if (str == "NSEC")
		return RdsDnsZone::NSEC;
	if (str == "NSEC3")
		return RdsDnsZone::NSEC3;
	if (str == "NSEC3PARAM")
		return RdsDnsZone::NSEC3PARAM;
	if (str == "PTR")
		return RdsDnsZone::PTR;
	if (str == "RRSIG")
		return RdsDnsZone::RRSIG;
	if (str == "SIG")
		return RdsDnsZone::SIG;
	if (str == "SOA")
		return RdsDnsZone::SOA;
	if (str == "SPF")
		return RdsDnsZone::SPF;
	if (str == "SRV")
		return RdsDnsZone::SRV;
	if (str == "SSHFP")
		return RdsDnsZone::SSHFP;
	if (str == "TA")
		return RdsDnsZone::TA;
	if (str == "TXT")
		return RdsDnsZone::TXT;
	return RdsDnsZone::Invalid;
}

QString RdsDnsZone::typeToString(RdsDnsZone::RecordType type)
{
	if (type == RdsDnsZone::A)
		return "A";
	if (type == RdsDnsZone::AAAA)
		return "AAAA";
	if (type == RdsDnsZone::AFSDB)
		return "AFSDB";
	if (type == RdsDnsZone::CERT)
		return "CERT";
	if (type == RdsDnsZone::CNAME)
		return "CNAME";
	if (type == RdsDnsZone::DHCID)
		return "DHCID";
	if (type == RdsDnsZone::DLV)
		return "DLV";
	if (type == RdsDnsZone::DNAME)
		return "DNAME";
	if (type == RdsDnsZone::DNSKEY)
		return "DNSKEY";
	if (type == RdsDnsZone::DS)
		return "DS";
	if (type == RdsDnsZone::HIP)
		return "HIP";
	if (type == RdsDnsZone::IPSECKEY)
		return "IPSECKEY";
	if (type == RdsDnsZone::KEY)
		return "KEY";
	if (type == RdsDnsZone::LOC)
		return "LOC";
	if (type == RdsDnsZone::MX)
		return "MX";
	if (type == RdsDnsZone::NAPTR)
		return "NAPTR";
	if (type == RdsDnsZone::NS)
		return "NS";
	if (type == RdsDnsZone::NSEC)
		return "NSEC";
	if (type == RdsDnsZone::NSEC3)
		return "NSEC3";
	if (type == RdsDnsZone::NSEC3PARAM)
		return "NSEC3PARAM";
	if (type == RdsDnsZone::PTR)
		return "PTR";
	if (type == RdsDnsZone::RRSIG)
		return "RRSIG";
	if (type == RdsDnsZone::SIG)
		return "SIG";
	if (type == RdsDnsZone::SOA)
		return "SOA";
	if (type == RdsDnsZone::SPF)
		return "SPF";
	if (type == RdsDnsZone::SRV)
		return "SRV";
	if (type == RdsDnsZone::SSHFP)
		return "SSHFP";
	if (type == RdsDnsZone::TA)
		return "TA";
	if (type == RdsDnsZone::TXT)
		return "TXT";
	return QString::Null();
}



