/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDNSRECORD_H
#define RDSDNSRECORD_H

#include <rdsglobal.h>
#include <RdsDnsZone>
#include <QxtPimpl>

class RdsDnsRecordPrivate;
RDS_SHARED_EXPORT QDataStream& operator>> (QDataStream& s, RdsDnsRecord& p);
RDS_SHARED_EXPORT QDataStream& operator<< (QDataStream& s, const RdsDnsRecord& p);

/**
	@author Chris Vickery <chris@resara.com>
 */
class RDS_SHARED_EXPORT RdsDnsRecord
{
	QXT_DECLARE_PRIVATE(RdsDnsRecord);
	friend RDS_SHARED_EXPORT QDataStream& operator>> (QDataStream& s, RdsDnsRecord& p);
	friend RDS_SHARED_EXPORT QDataStream& operator<< (QDataStream& s, const RdsDnsRecord& p);
public:
	RdsDnsRecord();
	RdsDnsRecord(const RdsDnsRecord& other);
	RdsDnsRecord(QString id);
	RdsDnsRecord& operator=(const RdsDnsRecord& other);
	bool operator==(const RdsDnsRecord& other) const;

	RdsDnsZone::RecordType type() const;
	void setType(RdsDnsZone::RecordType type);
	QString key() const;
	void setKey(const QString &key);
	QString value() const;
	void setValue(const QString &value);
	QStringList comments() const;
	void setComments(const QStringList &comments);
	QString origin() const;
	void setOrigin(const QString &origin);
	QString ttl() const;
	void setTtl(const QString &ttl);
	QString id(QString domain);
};

typedef QList<RdsDnsRecord> RdsDnsRecordList;

QTRPC_REGISTER_METATYPE(RdsDnsRecord);
Q_DECLARE_METATYPE(RdsDnsRecord);
QTRPC_REGISTER_METATYPE(RdsDnsRecordList);
Q_DECLARE_METATYPE(RdsDnsRecordList);

#endif


