/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSVOLUMEMANAGER_H
#define RDSVOLUMEMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>

class QDBusObjectPath;

class RdsVolumeManagerPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsVolumeManager : public RdsEntityManager
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsVolumeManager);
	QTRPC_SERVICEPROXY_PIMPL(RdsVolumeManager);

public:
	RdsVolumeManager();
	RdsVolumeManager(const RdsVolumeManager &other);
	~RdsVolumeManager();
	RdsVolumeManager& operator=(const RdsVolumeManager &other);
	ReturnValue listEntities(const QString&, bool) const;

public slots:
	QtRpc::ReturnValue auth(QtRpc::AuthToken token);
	ReturnValue list() const;
	ReturnValue rootVolume() const;
	ReturnValue defaultVolume() const;
	ReturnValue volume(const QString &name);
	ReturnValue addVolume(const QString &vol, const QString &name);
	ReturnValue removeVolume(const QString &name);


private slots:
	// Private API's... These slots go to
	void deviceAdded(const QDBusObjectPath &device);
	void deviceChanged(const QDBusObjectPath &device);
	void deviceRemoved(const QDBusObjectPath &device);
};

#endif
