/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdssinglevolume.h"
#include "rdsstoragemanager_p.h"
#include "rdssinglevolume_p.h"
#include "rdsudisksinterface.h"

#include <dbus/dbus.h>
#include <sys/vfs.h>
#include <errno.h>

using namespace QtRpc;

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsSingleVolume);
RDS_REGISTER_VOLUME(RdsSingleVolume);

bool RdsSingleVolumePrivate::hasUDisks()
{
	static bool hasUDisksCache = false;
	static unsigned char rotater = 0;
	rotater++;
	if ((rotater & 0x01) != 0x01)
		return hasUDisksCache;

	int major, minor, micro;
	dbus_get_version(&major, &minor, &micro);
	if (major < 1)
	{
		hasUDisksCache = false;
		return false;
	}
	if (major == 1 && minor < 4)
	{
		hasUDisksCache = false;
		return false;
	}

	RdsUDisksInterface interface(RdsUDisksInterface::staticInterfaceName(), "/org/freedesktop/UDisks", QDBusConnection::systemBus());
	QDBusPendingReply<QList<QDBusObjectPath> > ret = interface.EnumerateDevices();

	ret.waitForFinished();
	if (ret.value().count() < 1)
	{
		hasUDisksCache = false;
		return false;
	}

	hasUDisksCache = true;
	return true;
}

RdsSingleVolume::RdsSingleVolume()
{
}

RdsSingleVolume::RdsSingleVolume(const RdsSingleVolume& other)
{
}

RdsSingleVolume::~RdsSingleVolume()
{
}

RdsSingleVolume& RdsSingleVolume::operator=(const RdsSingleVolume & other)
{
}

ReturnValue RdsSingleVolume::initialize()
{
	return true;
}

ReturnValue RdsSingleVolume::isAdded() const
{
	return true;
}

ReturnValue RdsSingleVolume::isActivated() const
{
	return true;
}

ReturnValue RdsSingleVolume::storageDevice()
{
	return ReturnValue(1, "This action cannot be done on the 'Hard Disk' volume");
}

ReturnValue RdsSingleVolume::mountPoint() const
{
	return "/";
}

ReturnValue RdsSingleVolume::mount()
{
	QDir().mkdir("/volumes/Hard Drive");
	return true;
}

ReturnValue RdsSingleVolume::mount(const QString &path, const QStringList &options)
{
	return true;
}

ReturnValue RdsSingleVolume::unmount()
{
	return ReturnValue(1, "Cannot unmount 'Hard Disk'");
}

ReturnValue RdsSingleVolume::isMounted() const
{
	return true;
}

ReturnValue RdsSingleVolume::deviceFile() const
{
	return "/dev/zero";
}

ReturnValue RdsSingleVolume::path() const
{
	return "/volumes/Hard Drive";
}

ReturnValue RdsSingleVolume::size() const
{
	struct statfs buff;
	int ret = statfs("/volumes/Hard Drive", &buff);
	if (ret != 0)
		return ReturnValue(1, "Error while reading info about the filesystem: " + QString(strerror(errno)));
	qulonglong size = buff.f_blocks;
	size *= buff.f_bsize;
	return size;
}

ReturnValue RdsSingleVolume::freeSpace() const
{
	struct statfs buff;
	int ret = statfs("/volumes/Hard Drive", &buff);
	if (ret != 0)
		return ReturnValue(1, "Error while reading info about the filesystem: " + QString(strerror(errno)));
	qulonglong size = buff.f_bfree;
	size *= buff.f_bsize;
	return size;
}

ReturnValue RdsSingleVolume::fsType() const
{
	/*
	ADFS_SUPER_MAGIC      0xadf5
	AFFS_SUPER_MAGIC      0xADFF
	BEFS_SUPER_MAGIC      0x42465331
	BFS_MAGIC             0x1BADFACE
	CIFS_MAGIC_NUMBER     0xFF534D42
	CODA_SUPER_MAGIC      0x73757245
	COH_SUPER_MAGIC       0x012FF7B7
	CRAMFS_MAGIC          0x28cd3d45
	DEVFS_SUPER_MAGIC     0x1373
	EFS_SUPER_MAGIC       0x00414A53
	EXT_SUPER_MAGIC       0x137D
	EXT2_OLD_SUPER_MAGIC  0xEF51
	EXT2_SUPER_MAGIC      0xEF53
	EXT3_SUPER_MAGIC      0xEF53
	HFS_SUPER_MAGIC       0x4244
	HPFS_SUPER_MAGIC      0xF995E849
	HUGETLBFS_MAGIC       0x958458f6
	ISOFS_SUPER_MAGIC     0x9660
	JFFS2_SUPER_MAGIC     0x72b6
	JFS_SUPER_MAGIC       0x3153464a
	MINIX_SUPER_MAGIC     0x137F  // orig. minix
	MINIX_SUPER_MAGIC2    0x138F // 30 char minix
	MINIX2_SUPER_MAGIC    0x2468 // minix V2
	MINIX2_SUPER_MAGIC2   0x2478 // minix V2, 30 char names
	MSDOS_SUPER_MAGIC     0x4d44
	NCP_SUPER_MAGIC       0x564c
	NFS_SUPER_MAGIC       0x6969
	NTFS_SB_MAGIC         0x5346544e
	OPENPROM_SUPER_MAGIC  0x9fa1
	PROC_SUPER_MAGIC      0x9fa0
	QNX4_SUPER_MAGIC      0x002f
	REISERFS_SUPER_MAGIC  0x52654973
	ROMFS_MAGIC           0x7275
	SMB_SUPER_MAGIC       0x517B
	SYSV2_SUPER_MAGIC     0x012FF7B6
	SYSV4_SUPER_MAGIC     0x012FF7B5
	TMPFS_MAGIC           0x01021994
	UDF_SUPER_MAGIC       0x15013346
	UFS_MAGIC             0x00011954
	USBDEVICE_SUPER_MAGIC 0x9fa2
	VXFS_SUPER_MAGIC      0xa501FCF5
	XENIX_SUPER_MAGIC     0x012FF7B4
	XFS_SUPER_MAGIC       0x58465342
	_XIAFS_SUPER_MAGIC    0x012FD16D
	*/
	struct statfs buff;
	int ret = statfs("/volumes/Hard Drive", &buff);
	if (ret != 0)
		return ReturnValue(1, "Error while reading info about the filesystem: " + QString(strerror(errno)));
	switch (buff.f_type)
	{
		case 0xEF51:
			return "ext2";
		case 0xEF53:
			return "ext3";
		default:
			return "Other";
	}
}

ReturnValue RdsSingleVolume::type() const
{
	return "Hard Disk";
}

ReturnValue RdsSingleVolume::status() const
{
	return "Normal";
}

ReturnValue RdsSingleVolume::statusText() const
{
	return "Active";
}

ReturnValue RdsSingleVolume::statusDetails() const
{
	return "Active";
}

ReturnValue RdsSingleVolume::name()
{
	return "Hard Disk";
}

ReturnValue RdsSingleVolume::setName(const QString &name)
{
	return ReturnValue(1, "Cannot rename 'Hard Disk'");
}

ReturnValue RdsSingleVolume::id() const
{
	return "Hard Drive";
}

ReturnValue RdsSingleVolume::mkfs(const QString &type, const QStringList &options, quint64 blocks)
{
	return ReturnValue(1, "This action cannot be done on the 'Hard Disk' volume");
}

ReturnValue RdsSingleVolume::serialNumber() const
{
	return "4";
}

ReturnValue RdsSingleVolume::model() const
{
	return "Hard Disk";
}

ReturnValue RdsSingleVolume::isEjectable() const
{
	return false;
}

ReturnValue RdsSingleVolume::eject()
{
	return ReturnValue(1, "This action cannot be done on the 'Hard Disk' volume");
}


