/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSETTINGS_H
#define RDSSETTINGS_H

#include <QSettings>
#include <QxtPimpl>
namespace QtRpc
{
class ReturnValue;
}

class RdsSettingsPrivate;
class RdsSettings;
using QtRpc::ReturnValue;
RdsSettings rdssettings();

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsSettings
{
	// I made the usage paradigm for this forced via access and friending...
	friend RdsSettings rdssettings();
	QXT_DECLARE_PRIVATE(RdsSettings);
private:
	RdsSettings();
	RdsSettings(const RdsSettings &s);
public:
	~RdsSettings();
	QSettings *operator->();
	void lock();
	void unlock();
	ReturnValue renameGroup(const QString& oldname, const QString& newname);
};

/**  ONLY USE THIS FUNCTION TO ACCESS THIS CLASS */
inline RdsSettings rdssettings()
{
	return(RdsSettings());
}

#endif
