/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSJOBMANAGER_P_H
#define RDSJOBMANAGER_P_H

#include <QxtPimpl>
#include <QMutex>
#include <RdsJob>
#include "rdsjobmanager.h"

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsJobManagerData : public QObject
{
	Q_OBJECT;
public:
	RdsJobManagerData();
	QHash<QString, QSharedPointer<RdsJob> > jobs;
	QMutex mutex;

	ReturnValue registerJob(const QString &name, RdsJob* job);
	ReturnValue unregisterJob(const QString &name);
};

class RdsJobManagerPrivate : public QxtPrivate<RdsJobManager>
{
public:
	RdsJobManagerPrivate()
	{
	}

	static RdsJobManagerData& data();
};

#endif
