/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITYMANAGER_P_H
#define RDSENTITYMANAGER_P_H

#include <QMutex>
#include <QHash>
#include <ReturnValue>
#include <ServiceProxy>
#include "rdsentitymanager.h"

using namespace QtRpc;
class RdsEntityManager;

class EntityType : public QObject
{
	Q_OBJECT
public:
	EntityType(QObject *parent) : QObject(parent) {}

	QMultiHash<RdsEntityManager *, QString> _editing;

public slots:
	void addEntity(const QString &entity);
	void removeEntity(const QString &entity);
	void renameEntity(const QString &oldentity, const QString &newentity);
	void updateEntity(const QString &entity);
	void updateEntityMetadata(const QString &entity, const QVariantMap &metadata = QVariantMap());
	void startEditing(const QString &entity, RdsEntityManager *object);
	void stopEditing(const QString &entity, RdsEntityManager *object);
	void managerDestroyed(QObject *mgr);

signals:
	void entityAdded(const QString &entity);
	void entityRemoved(const QString &entity);
	void entityRenamed(const QString &oldentity, const QString &newentity);
	void entityUpdated(const QString &entity);
	void entityMetadataUpdated(const QString &entity, const QVariantMap &metadata = QVariantMap());
	void editingStarted(const QString &entity, RdsEntityManager *oject);
	void editingStopped(const QString &entity, RdsEntityManager *object);
};

class RdsEntityManagerPrivate : public QxtPrivate<RdsEntityManager>
{
public:
	RdsEntityManagerPrivate() {}

	static QMutex& mutex();
	static QHash<QString, EntityType *>& types();
};

#endif
