/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITYMANAGER_H
#define RDSENTITYMANAGER_H

#include <ServiceProxy>
#include <QxtPimpl>

class RdsEntityManagerPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsEntityManager : public QtRpc::ServiceProxy
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsEntityManager);
public:
	RdsEntityManager(QObject *parent = 0);
	RdsEntityManager(const RdsEntityManager &object);
	~RdsEntityManager();

	RdsEntityManager &operator = (const RdsEntityManager &object);
	void createInternalObject();
	virtual ReturnValue init();

public slots:
	virtual QtRpc::ReturnValue addEntity(const QString &entity);
	virtual QtRpc::ReturnValue removeEntity(const QString &entity);
	virtual QtRpc::ReturnValue renameEntity(const QString &oldentity, const QString &newentity);
	virtual QtRpc::ReturnValue updateEntity(const QString &entity);
	virtual QtRpc::ReturnValue updateEntityMetadata(const QString &entity, const QVariantMap &metadata = QVariantMap());
	virtual QtRpc::ReturnValue listEntities(const QString &base) const;
	virtual QtRpc::ReturnValue listEntities(const QString &base, bool loadmore) const = 0;
	virtual QtRpc::ReturnValue startEditing(const QString &entity);
	virtual QtRpc::ReturnValue stopEditing(const QString &entity);
	virtual void editingStarted(const QString &entity, RdsEntityManager *object);
	virtual void editingStopped(const QString &entity, RdsEntityManager *object);
	virtual QtRpc::ReturnValue editingList();

signals:
	QtRpc::Event entityAdded(const QString &entity);
	QtRpc::Event entityRemoved(const QString &entity);
	QtRpc::Event entityRenamed(const QString &oldentity, const QString &newentity);
	QtRpc::Event entityUpdated(const QString &entity);
	QtRpc::Event entityMetadataUpdated(const QString &entity, const QVariantMap &metadata = QVariantMap());
	QtRpc::Event editingStarted(const QString &entity);
	QtRpc::Event editingStopped(const QString &entity);
};

#endif
