/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDNSMANAGER_P_H
#define RDSDNSMANAGER_P_H

#include <QxtPimpl>
#include <QSharedData>
#include <QStringList>
#include <QHash>
#include <QExplicitlySharedDataPointer>
#include <QMutex>

#include "rdsdnsmanager.h"

QVariantMap recursivelyUnite(const QVariantMap& map, const QVariantMap& other);
QVariantMap insertData(QVariantMap map, QStringList breadCrumb, QVariant value);

class RdsDnsManagerData : public QSharedData
{
public:
	struct RdsZoneInfo
	{
		QString zoneKey;
		QString zone;
		QVariantMap values;
	}; //file

	RdsDnsManagerData()
			: mutex(QMutex::Recursive),
			valid(false),
			parsed(false)
	{ }

	QMutex* getMutex() const
	{
		return const_cast<QMutex*>(&mutex);
	}
	QMutex mutex;
	QVariantMap comments;
	QVariantMap values;
	QHash<QString, RdsZoneInfo> zones;
	QStringList forwarders;
	bool valid;
	bool parsed;
	QString errorString;
};

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsDnsManagerPrivate : public QxtPrivate<RdsDnsManager>
{
public:
	RdsDnsManagerPrivate()
			: data(&staticData())
	{
	}
	RdsDnsManagerData* data;
	static RdsDnsManagerData& staticData();

};

#endif
