/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsdhcpgroup.h"
#include "rdsdhcpgroup_p.h"

#define RDS_LOCK \
	QMutexLocker ___locker(&RdsDhcpManagerPrivate::mutex()); \
	if(!qxt_d().values) \
		return ReturnValue(1, "Internal data object is missing in RdsDhcpGroup");

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsDhcpGroup);

RdsDhcpGroup::RdsDhcpGroup()
		: RdsDhcpValues()
{
}

RdsDhcpGroup::RdsDhcpGroup(const RdsDhcpGroup &other)
		: RdsDhcpValues(other)
{
}

RdsDhcpGroup::~RdsDhcpGroup()
{
}

RdsDhcpGroup& RdsDhcpGroup::operator=(const RdsDhcpGroup & other)
{
	RdsDhcpValues::operator=(other);
	return *this;
}

void RdsDhcpGroup::setData(void* data)
{
	QMutexLocker ___locker(&RdsDhcpManagerPrivate::mutex());
	qxt_d().values = static_cast<RdsDhcpManagerPrivate::Group*>(data);
	RdsDhcpValues::setData(data);
}

ReturnValue RdsDhcpGroup::name() const
{
	RDS_LOCK;
	return qxt_d().values->name;
}

ReturnValue RdsDhcpGroup::setName(const QString &name)
{
	RDS_LOCK;
	if (qxt_d().values->parent)
	{
		qxt_d().values->parent->groups.remove(qxt_d().values->name);
		qxt_d().values->parent->groups.insert(name, qxt_d().values);
	}
	qxt_d().values->name = name;
	return true;
}




