/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSLDAPACTIONS_P_H
#define RDSLDAPACTIONS_P_H
 
#include <QObject>
#include <QxtPimpl>
#include <QPointer>
#include <QSharedPointer>
#ifndef __RDS_CLIENT
#include <ldap.h>
#include "lutil_ldap.h"
#endif
#include <QDebug>
#include "rdsldapactions.h"

struct LdapAction
{
	RdsLdapActions::ActionType type;
	QString name;
	QList<QByteArray> values;
	bool data;
};

class RdsLdapActionsPrivate : public QxtPrivate<RdsLdapActions>
{
	public:
		QXT_DECLARE_PUBLIC(RdsLdapActions);
		RdsLdapActionsPrivate() {}

		QList<LdapAction> actions;
};

#endif
