/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsldapactions.h"
#include "rdsldapactions_p.h"

QTRPC_REGISTER_METATYPE(RdsLdapActions);

using namespace QtRpc;

RdsLdapActions::RdsLdapActions()
{
	QXT_INIT_PRIVATE(RdsLdapActions);
}

RdsLdapActions::RdsLdapActions(const RdsLdapActions &actions)
{
	QXT_INIT_PRIVATE(RdsLdapActions);
	qxt_d().actions = actions.getActions();
}

RdsLdapActions::RdsLdapActions(const QList<LdapAction> &actions)
{
	QXT_INIT_PRIVATE(RdsLdapActions);
	qxt_d().actions = actions;
}

RdsLdapActions::~RdsLdapActions()
{

}

void RdsLdapActions::add(const ActionType &type, const QString &name, const QString &value)
{
	LdapAction action;
	action.type = type;
	action.name = name;
	if ((type == Remove) && (value == ""))
		action.values = QList<QByteArray>();
	else
		action.values = QList<QByteArray>() << value.toAscii();
	action.data = false;
	qxt_d().actions << action;
}

void RdsLdapActions::addData(const ActionType &type, const QString &name, const QByteArray &value)
{
	LdapAction action;
	action.type = type;
	action.name = name;
	action.values = QList<QByteArray>() << value;
	action.data = true;
	qxt_d().actions << action;
}

void RdsLdapActions::addUnicode(const ActionType &type, const QString &name, const QString &value)
{
	return(addUnicode(type, name, QStringList() << value));
}

void RdsLdapActions::addUnicode(const ActionType &type, const QString &name, const QStringList &values)
{
	QList<QByteArray> list;
	foreach(QString value, values)
	{
		const ushort *unicode = value.utf16();
		list << QByteArray((char *)unicode, sizeof(ushort)*(value.length()));
	}

	LdapAction action;
	action.type = type;
	action.name = name;
	action.values = list;
	action.data = true;
	qxt_d().actions << action;
}

void RdsLdapActions::add(const ActionType &type, const QString &name, const QList<QString> &values)
{
	QList<QByteArray> newvals;
	foreach(QString val, values)
	{
		newvals << val.toAscii();
	}

	LdapAction action;
	action.type = type;
	action.name = name;
	action.values = newvals;
	action.data = false;
	qxt_d().actions << action;
}

void RdsLdapActions::addData(const ActionType &type, const QString &name, const QList<QByteArray> &values)
{
	LdapAction action;
	action.type = type;
	action.name = name;
	action.values = values;
	action.data = true;
	qxt_d().actions << action;
}

void RdsLdapActions::clear()
{
	qxt_d().actions.clear();
}

QList<LdapAction> RdsLdapActions::getActions() const
{
	return(qxt_d().actions);
}

RdsLdapActions & RdsLdapActions::operator=(const RdsLdapActions & object)
{
	qxt_d().actions = object.getActions();
	return(*this);
}

#ifndef __RDS_CLIENT
LDAPMod **RdsLdapActions::getLdapActions() const
{
	LDAPMod **mods = (LDAPMod **)malloc(sizeof(LDAPMod *) * (qxt_d().actions.size() + 1));
	int i = 0;
	foreach(LdapAction action, qxt_d().actions)
	{
		LDAPMod *mod = (LDAPMod *)malloc(sizeof(LDAPMod));
		mod->mod_type = strdup(action.name.toAscii().data());
		switch (action.type)
		{
			case Add:
				mod->mod_op = LDAP_MOD_ADD;
				break;
			case Replace:
				mod->mod_op = LDAP_MOD_REPLACE;
				break;
			case Remove:
				mod->mod_op = LDAP_MOD_DELETE;
				break;
		}

		if ((action.type != Remove) || (action.values.size() != 0))
		{
			if (action.data)
			{
				struct berval **values = (struct berval **)malloc(sizeof(struct berval *) * (action.values.size() + 1));
				int j = 0;
				foreach(QByteArray value, action.values)
				{
					struct berval *val = (struct berval *)malloc(sizeof(struct berval));
					val->bv_len = value.size();
					val->bv_val = (char *)malloc(sizeof(char) * value.size());
					memcpy(val->bv_val, value.constData(), sizeof(char) * value.size());
					values[j] = val;
					j++;
				}
				values[j] = NULL;
				mod->mod_bvalues = values;
				mod->mod_op |= LDAP_MOD_BVALUES;
			}
			else
			{
				char **values = (char **)malloc(sizeof(char *) * (action.values.size() + 1));
				int j = 0;
				foreach(QByteArray value, action.values)
				{
					values[j] = strdup(value.data());
					j++;
				}
				values[j] = NULL;
				mod->mod_values = values;
			}
		}
		else
		{
			mod->mod_values = NULL;
		}


		mods[i] = mod;
		i++;
	}

	mods[i] = NULL;

	return(mods);
}
#endif
QDataStream& operator<<(QDataStream& d, const RdsLdapActions& object)
{
	QList<LdapAction> actions = object.getActions();
	d << actions.size();

	foreach(LdapAction action, actions)
	{
		d << (int)action.type;
		d << action.name;
		d << action.values;
		d << action.data;
	}
	return(d);
}

QDataStream& operator>>(QDataStream& d, RdsLdapActions& object)
{
	QList<LdapAction> actions;
	int size;

	d >> size;
	for (int i = 0; i < size; i++)
	{
		LdapAction action;
		int type;
		d >> type;
		action.type = (RdsLdapActions::ActionType)type;
		d >> action.name;
		d >> action.values;
		d >> action.data;
		actions << action;
	}

	object = RdsLdapActions(actions);
	return(d);
}
