/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSNETWORKSETTINGSTHREAD_H
#define RDSNETWORKSETTINGSTHREAD_H

#include <QThread>
#include <QVariantMap>
#include <ReturnValue>
#include "rdsprovisionator.h"

class RdsProvisionator;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsNetworkSettingsThread : public QThread
{
	Q_OBJECT;
	Q_DISABLE_COPY(RdsNetworkSettingsThread);
public:
	RdsNetworkSettingsThread(RdsProvisionator *parent);
	~RdsNetworkSettingsThread();

	ReturnValue start(const QVariantMap &settings);
	static ReturnValue updateHostsFile(QVariantMap settings);
	
protected:
	void run();
	using QThread::start;

	ReturnValue updateHostsFile();
	ReturnValue updateResolveFile();
	ReturnValue updateDns();
	ReturnValue restartSamba();
	ReturnValue publishServices();
	void completed(const ReturnValue &ret);
	void sendMajorProgress(const QString &str);
	void sendMinorProgress(const QString &str);

private:
	QVariantMap _settings;
	RdsProvisionator* _service;
};

#endif
