/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSNETMONITORTHREAD_H
#define RDSNETMONITORTHREAD_H

#include <QThread>
#include <QTimer>
#include <QMutex>
#include <QStringList>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsNetMonitorThread : public QThread
{
	Q_OBJECT
public:
	RdsNetMonitorThread(QString interface, QString ip, QString netmask, QString gateway, QStringList dns,
	                    QString oldip, QString oldnetmask, QString oldgateway, QStringList olddns, bool updatehosts, QObject *parent = 0);
	~RdsNetMonitorThread();

	void run();
	void cancel();

protected slots:
	void timeout();

private:
	QString _interface;
	QString _ip;
	QString _netmask;
	QString _gateway;
	QStringList _dns;
	QString _oldip;
	QString _oldnetmask;
	QString _oldgateway;
	QStringList _olddns;
	bool _canceled;
	QMutex _canceledmutex;
	bool _updatehosts;
};

#endif
