/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSCHECKIN_H
#define RDSCHECKIN_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QMutex>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsCheckin : public QObject
{
	Q_OBJECT
public:
	RdsCheckin(QObject *parent = 0);
	~RdsCheckin();

	static RdsCheckin* instance();

signals:
	void finished();
	
public slots:
	void install();
	void checkin();
	void checkUpgrade();
	
private slots:
	void replyFinished(QNetworkReply* reply);
	
private:
	QString getLicenseType();
	QString getUid();
	QString getVersion();
	QString getArch();
	int getNumCores();
	int getRam();
	QString getDistribution();
	int getNumUsers();
	int getNumGroups();
	int getNumComputers();
	int getNumDcs();
	int getNumOus();
	int getNumShares();
	int getNumMaps();
	
	QNetworkAccessManager *_manager;
	QMutex _mutex;
	static RdsCheckin *_instance;
};

#endif
