/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef USERMANAGERWIDGET_H
#define USERMANAGERWIDGET_H

#include <QWidget>
#include "ui_usermanagerwidget.h"
#include "rdsusergroupcomputermodel.h"
#include <RdsEntityManager>
#include <RdsEntitySortModel>
#include <QItemSelectionModel>
#include <RdsEntityWidget>
#include <RdsSid>
#include "rdsusergroupcomputersortmodel.h"

class UserManagerWidget : public QWidget, private Ui::UserManagerWidget
{
	Q_OBJECT

public:
	UserManagerWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~UserManagerWidget();

public slots:
	void inputChanged(QString id, QString type);
	void outputsChanged(QStringList outputs);

protected slots:
	void AddUser();
	void AddGroup();
	void AddOu();
	void on_DeleteButton_clicked();
	void contextMenu(const QPoint & pos);
	void setPassword();
	void showUsers(bool show);
	void showGroups(bool show);
	void showSystemObjects(bool show);
	void cloneUser();
	void on_ReloadButton_clicked();

private:
	void addSystemId(RdsSid sid);
	void addSystemId(int id);
	void addSystemIdByName(QString name);
	void addProtectedId(RdsSid sid);
	void addProtectedId(int id);
	void addProtectedIdByName(QString name);
	RdsUserGroupComputerModel *_model;
	RdsUserGroupComputerSortModel *_sort;
	RdsEntityManager *_manager;
	QItemSelectionModel *_selection;
	RdsEntityWidget *_edit;
	QString _input;
	QAction *_newuseraction;
	QAction *_newgroupaction;
	QAction *_newouaction;
	QAction *_removeaction;
	QAction *_setpasswordaction;
	QAction *_showusersaction;
	QAction *_showgroupsaction;
	QAction *_showsystemaction;
	QAction *_cloneuseraction;
};

#endif

