/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef USERGROUPSWIDGET_H
#define USERGROUPSWIDGET_H

#include <QWidget>
#include "ui_usergroupswidget.h"

class UserGroupsWidget : public QWidget, private Ui::UserGroupsWidget
{
	Q_OBJECT

public:
	Q_PROPERTY(QStringList groups READ groups WRITE setGroups);
	UserGroupsWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~UserGroupsWidget();

	void setGroups(QStringList groups);
	QStringList groups();

signals:
	void changed();

protected slots:
	void on_AddButton_clicked();
	void on_RemoveButton_clicked();

private:
	QStringList _groups;
	QStringList _names;
};

#endif

