/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "usergroupswidget.h"
#include <RdsGroup>
#include <QDebug>
#include "selectiondialog.h"
#include "config.h"

UserGroupsWidget::UserGroupsWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::UserGroupsWidget()
{
	setupUi(this);
	AddButton->setIcon(QPixmap(findRdsIcon("icons/32x32/add.png")));
	RemoveButton->setIcon(QPixmap(findRdsIcon("icons/32x32/remove.png")));
}

UserGroupsWidget::~UserGroupsWidget()
{
}

void UserGroupsWidget::setGroups(QStringList groups)
{
	GroupList->clear();
	_names = QStringList();

	foreach(QString group, groups)
	{
		RdsGroup g(group);
		QString name;
		ReturnValue ret = g.cn();
		if (ret.isError())
			name = group;
		else
			name = ret.toString();

		_names << name;

		GroupList->addItem(new QListWidgetItem(QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16),
		                                       name, GroupList));
	}

	_groups = groups;
}

QStringList UserGroupsWidget::groups()
{
	QStringList tmp = _groups;
	tmp.sort();
	return(tmp);
}

void UserGroupsWidget::on_AddButton_clicked()
{
	SelectionDialog dialog(SelectionDialog::Group, this);
	dialog.setAllowMultipleSelections(true);
	if (dialog.exec())
	{
		foreach(QString group, dialog.selectedItems())
		{
			if (_groups.contains(group)) continue;

			RdsGroup g(group);
			QString name;
			ReturnValue ret = g.cn();
			if (ret.isError())
				name = group;
			else
				name = ret.toString();

			_names << name;
			_groups << group;

			GroupList->addItem(new QListWidgetItem(QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16),
			                                       name, GroupList));
		}
		emit(changed());
	}
}

void UserGroupsWidget::on_RemoveButton_clicked()
{
	//qDebug() << "CURRENT ROW:" << GroupList->currentRow();
	if (GroupList->currentRow() < 0) return;
	if (GroupList->currentRow() > _groups.size()) return;

	_groups.removeAt(GroupList->currentRow());
	_names.removeAt(GroupList->currentRow());
	GroupList->takeItem(GroupList->currentRow());

	emit(changed());
}
