/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef USEREDITWIDGET_H
#define USEREDITWIDGET_H

#include <QWidget>
#include <RdsEntityWidget>
#include "ui_usereditwidget.h"

class UserEditWidget : public RdsEntityWidget, private Ui::Form
{
	Q_OBJECT
public:
	UserEditWidget(RdsEntityManager *manager, QWidget* parent = 0);
	~UserEditWidget();

	virtual void setOutputs(QStringList outputs);

protected slots:
	void entityRenamed(QString oldid, QString newid);
	void on_ChangePassword_clicked();
	void on_MustChangePassword_toggled(bool state);
	void on_CannotChangePassword_toggled(bool state);
	void on_ProfileBrowseButton_clicked();
	void on_HomeBrowseButton_clicked();

protected:
	ReturnValue getData();
	bool setData(QString id, QVariantMap fields);
	void entityUpdated(QString id);
	void addCountry(QString name, QString abbr);

private:
	QHash<QString, QString> _countrytoabbr;
	QHash<QString, QString> _abbrtocountry;
};

#endif

